/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class OASchema {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)OASchema.class.getName());
    @JsonProperty(value="$ref")
    private String ref;
    private Type type;
    private Format format;
    private String description;
    @JsonProperty(value="default")
    private String deflt;
    private OASchema items;
    private Map<String, OASchema> properties;
    private Boolean additionalProperties;

    public OASchema(Type type, Format format) {
        this.type = type;
        this.format = format;
    }

    public OASchema(String ref) {
        this.ref = ref;
    }

    public OASchema(Property property) {
        this.type = Type.STRING;
        LOGGER.trace("TODO: sniff type from property: {}.", (Object)property);
    }

    public void addProperty(String name, OASchema property) {
        if (this.properties == null) {
            this.properties = new TreeMap<String, OASchema>();
        }
        this.properties.put(name, property);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDeflt() {
        return this.deflt;
    }

    public void setDeflt(String deflt) {
        this.deflt = deflt;
    }

    public OASchema getItems() {
        return this.items;
    }

    public void setItems(OASchema items) {
        this.items = items;
    }

    public Map<String, OASchema> getProperties() {
        return this.properties;
    }

    public Boolean getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Boolean additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public static enum Format {
        INT32,
        INT64,
        FLOAT,
        DOUBLE;

    }

    public static enum Type {
        STRING,
        NUMBER,
        INTEGER,
        OBJECT,
        ARRAY,
        BOOLEAN;

    }
}

