/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.openapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriterGeneric;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.GeneratorContext;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OADoc;
import de.fraunhofer.iosb.ilt.frostserver.plugin.openapi.spec.OpenApiGenerator;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceOpenApi {
    public static final String PATH_GET_OPENAPI_SPEC = "/api";
    public static final String REQUEST_TYPE_GET_OPENAPI_SPEC = "openApi";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ServiceOpenApi.class.getName());
    private final CoreSettings settings;

    public ServiceOpenApi(CoreSettings settings) {
        this.settings = settings;
    }

    public ServiceResponse executeRequest(ServiceRequest request, ServiceResponse response) {
        GeneratorContext context = new GeneratorContext(this.settings).initFromRequest(request);
        OADoc oaDoc = OpenApiGenerator.generateOpenApiDocument(context);
        try {
            String jsonString = SimpleJsonMapper.getSimpleObjectMapper().writeValueAsString((Object)oaDoc);
            response.setCode(200);
            response.setContentType("application/json");
            response.getWriter().append(new FormatWriterGeneric(jsonString).getFormatted());
            return response;
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Failed to encode OA Document.", (Throwable)ex);
            return Service.errorResponse((ServiceResponse)response, (int)500, (String)"Failed to encode document");
        }
        catch (IOException ex) {
            LOGGER.error("Failed to format response", (Throwable)ex);
            return Service.errorResponse((ServiceResponse)response, (int)500, (String)"Failed to format document");
        }
    }

    public static boolean paramValueAsBool(ServiceRequest request, String name, boolean dflt) {
        List values = (List)request.getParameterMap().get(name);
        if (values == null || values.isEmpty()) {
            return dflt;
        }
        String value = (String)values.get(0);
        if (value == null) {
            return dflt;
        }
        return value.equalsIgnoreCase("true");
    }

    public static int paramValueAsInt(ServiceRequest request, String name, int dflt) {
        List values = (List)request.getParameterMap().get(name);
        if (values == null || values.isEmpty()) {
            return dflt;
        }
        String value = (String)values.get(0);
        if (value == null) {
            return dflt;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }
}

