/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.deserialize.TimeValueDeserializer;
import java.io.IOException;
import net.time4j.Moment;

public class TimeIntervalDeserializer
extends StdDeserializer<TimeInterval> {
    public TimeIntervalDeserializer() {
        super(TimeInterval.class);
    }

    public TimeInterval deserialize(JsonParser parser, DeserializationContext dc) throws IOException {
        Moment start = null;
        Moment end = null;
        JsonToken currentToken = parser.nextToken();
        while (currentToken == JsonToken.FIELD_NAME) {
            String fieldName;
            switch (fieldName = parser.getCurrentName()) {
                case "start": {
                    start = TimeValueDeserializer.parseTime(parser);
                    break;
                }
                case "end": {
                    end = TimeValueDeserializer.parseTime(parser);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Found field " + fieldName + " expected one of: start, end");
                }
            }
            currentToken = parser.nextToken();
        }
        if (start == null && end == null) {
            return null;
        }
        if (start == null || end == null) {
            throw new IllegalArgumentException("Interval must have start and end fields.");
        }
        return TimeInterval.create(start, end);
    }
}

