/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata;

import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.LandingPageItem;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.MetaDataGenerator;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginResultFormatOData;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.deserialize.JsonReaderOData;
import de.fraunhofer.iosb.ilt.frostserver.service.InitResult;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginOData
implements PluginService,
ConfigDefaults {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)PluginOData.class.getName());
    public static final String VERSION_ODATA_40_NAME = "ODATA_4.0";
    public static final String VERSION_ODATA_401_NAME = "ODATA_4.01";
    public static final Version VERSION_ODATA_40 = new Version("ODATA_4.0", "@odata.count", "id", "@odata.navigationLink", "@odata.nextLink", "@odata.id");
    public static final Version VERSION_ODATA_401 = new Version("ODATA_4.01", "@count", "id", "@navigationLink", "@nextLink", "@id");
    public static final String PARAM_METADATA = "$metadata";
    public static final String PATH_METADATA = "/$metadata";
    public static final String REQUEST_TYPE_METADATA = "$metadata";
    @DefaultValueBoolean(value=false)
    public static final String TAG_ENABLE_ODATA = "odata.enable";
    private CoreSettings settings;
    private boolean enabled;

    public InitResult init(CoreSettings settings) {
        this.settings = settings;
        Settings pluginSettings = settings.getPluginSettings();
        this.enabled = pluginSettings.getBoolean(TAG_ENABLE_ODATA, this.getClass());
        if (this.enabled) {
            settings.getPluginManager().registerPlugin((Plugin)this);
            new PluginResultFormatOData().init(settings);
        }
        return InitResult.INIT_OK;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<Version> getVersions() {
        return Arrays.asList(VERSION_ODATA_40, VERSION_ODATA_401);
    }

    public boolean definesVersions() {
        return true;
    }

    public Collection<String> getVersionedUrlPaths() {
        return Arrays.asList(PATH_METADATA, "*");
    }

    public Collection<String> getRequestTypes() {
        return Arrays.asList("getCapabilities", "create", "delete", "read", "updateAll", "updateChanged", "updateChangeset", "$metadata");
    }

    public String getRequestTypeFor(Version version, String path, HttpMethod method, String contentType) {
        if (version != VERSION_ODATA_40 && version != VERSION_ODATA_401) {
            return null;
        }
        if (path.startsWith(PATH_METADATA)) {
            return "$metadata";
        }
        switch (method) {
            case DELETE: {
                return "delete";
            }
            case HEAD: 
            case GET: {
                if (path.isEmpty() || "/".equals(path)) {
                    return "getCapabilities";
                }
                return "read";
            }
            case PATCH: {
                if (!StringHelper.isNullOrEmpty((String)contentType) && contentType.startsWith("application/json-patch+json")) {
                    return "updateChangeset";
                }
                return "updateChanged";
            }
            case POST: {
                return "create";
            }
            case PUT: {
                return "updateAll";
            }
        }
        return null;
    }

    public ServiceResponse execute(Service mainService, ServiceRequest request, ServiceResponse response) {
        boolean isOdata401 = false;
        if (request.getVersion() == VERSION_ODATA_40) {
            response.addHeader("OData-Version", "4.0");
        } else {
            isOdata401 = true;
            response.addHeader("OData-Version", "4.01");
        }
        request.setJsonReader((JsonReader)new JsonReaderOData(request.getCoreSettings().getModelRegistry(), request.getUserPrincipal()));
        switch (request.getRequestType()) {
            case "$metadata": {
                return new MetaDataGenerator(this.settings).generateMetaData(request, response);
            }
            case "getCapabilities": {
                return this.executeGetCapabilities(request, response);
            }
            case "create": {
                if ("minimal".equalsIgnoreCase(request.getParameter("return"))) {
                    request.addParameterIfAbsent("$format", "noResponse");
                }
                request.setUpdateMode(isOdata401 ? UpdateMode.INSERT_ODATA_401 : UpdateMode.INSERT_ODATA_40);
                return mainService.execute(request, response);
            }
            case "updateAll": 
            case "updateChanged": 
            case "updateChangeset": {
                if ("minimal".equalsIgnoreCase(request.getParameter("return"))) {
                    request.addParameterIfAbsent("$format", "noResponse");
                }
                request.setUpdateMode(isOdata401 ? UpdateMode.UPDATE_ODATA_401 : UpdateMode.UPDATE_ODATA_40);
                return mainService.execute(request, response);
            }
        }
        return mainService.execute(request, response);
    }

    private ServiceResponse executeGetCapabilities(ServiceRequest request, ServiceResponse response) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        ModelRegistry modelRegistry = this.settings.getModelRegistry();
        String path = request.getQueryDefaults().getServiceRootUrl() + "/" + request.getVersion().urlPart + "/";
        if (request.getVersion() == VERSION_ODATA_40) {
            result.put("@odata.context", path + "$metadata");
        } else {
            result.put("@context", path + "$metadata");
        }
        ArrayList<LandingPageItem> entitySetList = new ArrayList<LandingPageItem>();
        result.put("value", entitySetList);
        for (EntityType entityType : modelRegistry.getEntityTypes(request.getUserPrincipal().isAdmin())) {
            entitySetList.add(new LandingPageItem().generateFrom(entityType, path));
        }
        this.settings.getPluginManager().modifyServiceDocument(request, result);
        try {
            SimpleJsonMapper.getSimpleObjectMapper().writeValue(response.getWriter(), result);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to generate index document", (Throwable)ex);
        }
        response.setCode(200);
        response.setResult(result);
        return response;
    }

    static {
        PluginOData.VERSION_ODATA_40.syntheticPropertyRegistry.registerProperty("@odata.id", ModelRegistry.EP_SELFLINK);
        PluginOData.VERSION_ODATA_40.responses.put(Version.CannedResponseType.NOTHING_FOUND, new Version.CannedResponse(204, "No Content"));
        PluginOData.VERSION_ODATA_401.syntheticPropertyRegistry.registerProperty("@id", ModelRegistry.EP_SELFLINK);
        PluginOData.VERSION_ODATA_401.responses.put(Version.CannedResponseType.NOTHING_FOUND, new Version.CannedResponse(204, "No Content"));
    }
}

