/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntitySetResultOdata;
import java.io.IOException;

public class EntitySetResultOdataSerializer
extends JsonSerializer<EntitySetResultOdata> {
    private final String contextField;
    private final String countField;
    private final String nextLinkField;

    public EntitySetResultOdataSerializer(String contextField, String countField, String nextLinkField) {
        this.contextField = contextField;
        this.countField = countField;
        this.nextLinkField = nextLinkField;
    }

    public void serialize(EntitySetResultOdata value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField(this.contextField, value.getContext());
        long count = value.getValues().getCount();
        if (count >= 0L) {
            gen.writeNumberField(this.countField, count);
        }
        gen.writeArrayFieldStart("value");
        for (Entity child : value.getValues()) {
            gen.writeObject((Object)child);
        }
        gen.writeEndArray();
        String nextLink = value.getValues().getNextLink();
        if (nextLink != null) {
            gen.writeStringField(this.nextLinkField, nextLink);
        }
    }

    public boolean isEmpty(SerializerProvider provider, EntitySetResultOdata value) {
        return value == null || value.getValues() == null;
    }
}

