/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlAnnotation;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsdlPropertyEntity
implements CsdlProperty {
    private static final String TYPE_DEFAULT = "Edm.String";
    @JsonProperty(value="$Type")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public String type;
    @JsonProperty(value="$Nullable")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean nullable;
    @JsonProperty(value="$Collection")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean collection;
    @JsonIgnore
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    public CsdlPropertyEntity generateFrom(CsdlDocument doc, Version version, String nameSpace, EntityType et, EntityPropertyMain<?> ep) {
        PropertyType propertyType = ep.getType();
        this.type = propertyType.getName();
        this.collection = propertyType.isCollection();
        if (!this.type.startsWith("Edm.")) {
            this.type = nameSpace + "." + this.type;
        }
        if (TYPE_DEFAULT.equals(this.type)) {
            this.type = null;
        }
        if (TypeSimplePrimitive.EDM_UNTYPED == propertyType && version == PluginOData.VERSION_ODATA_40) {
            this.type = TypeSimplePrimitive.EDM_STRING.getName();
        }
        if (!et.getPrimaryKey().getKeyProperties().contains(ep)) {
            this.nullable = ep.isNullable();
        }
        for (Annotation an : ep.getAnnotations()) {
            this.annotations.add(new CsdlAnnotation().generateFrom(doc, an));
        }
        return this;
    }

    public CsdlPropertyEntity generateFrom(CsdlDocument doc, String nameSpace, PropertyType value, boolean nullable) {
        this.type = value.getName();
        if (!this.type.startsWith("Edm.")) {
            this.type = nameSpace + "." + this.type;
        }
        if (TYPE_DEFAULT.equals(this.type)) {
            this.type = null;
        }
        this.nullable = nullable;
        for (Annotation an : value.getAnnotations()) {
            this.annotations.add(new CsdlAnnotation().generateFrom(doc, an));
        }
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> otherProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (CsdlAnnotation annotation : this.annotations) {
            result.put("@" + annotation.getQualifiedName(), annotation.getValue());
        }
        return result;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        Object typeString;
        Object object = typeString = this.type == null ? TYPE_DEFAULT : this.type;
        if (this.collection) {
            typeString = "Collection(" + (String)typeString + ")";
        }
        String nullableString = this.nullable ? " Nullable=\"" + Boolean.toString(this.nullable) + "\"" : "";
        writer.write("<Property Name=\"" + name + "\" Type=\"" + (String)typeString + "\"" + nullableString);
        if (this.annotations.isEmpty()) {
            writer.write(" />");
        } else {
            writer.write(">");
            for (CsdlAnnotation an : this.annotations) {
                an.writeXml(writer);
            }
            writer.write("</Property>");
        }
    }
}

