/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlPropertyEntity;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlSchemaItem;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;

public class CsdlItemComplexType
implements CsdlSchemaItem {
    @JsonProperty(value="$Kind")
    public String kind = "ComplexType";
    @JsonProperty(value="$OpenType")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean openType;
    @JsonProperty(value="@Core.Description")
    public String description;
    @JsonAnyGetter
    @JsonAnySetter
    public Map<String, CsdlProperty> properties = new LinkedHashMap<String, CsdlProperty>();

    public CsdlItemComplexType generateFrom(CsdlDocument doc, String nameSpace, TypeComplex tc) {
        this.description = tc.getDescription();
        this.openType = tc.isOpenType();
        for (Map.Entry entry : tc.getPropertiesByName().entrySet()) {
            String name = (String)entry.getKey();
            Property prop = (Property)entry.getValue();
            boolean nullable = prop.isNullable();
            this.properties.put(name, new CsdlPropertyEntity().generateFrom(doc, nameSpace, prop.getType(), nullable));
        }
        return this;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<ComplexType Name=\"" + name + "\" OpenType=\"" + Boolean.toString(this.openType) + "\">");
        for (Map.Entry<String, CsdlProperty> entry : this.properties.entrySet()) {
            String propName = entry.getKey();
            CsdlProperty property = entry.getValue();
            property.writeXml(nameSpace, propName, writer);
        }
        writer.write("</ComplexType>");
    }
}

