/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import net.time4j.Moment;
import net.time4j.range.MomentInterval;

public class TimeValueSerializer
extends JsonSerializer<TimeValue> {
    public void serialize(TimeValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        if (value.isEmpty()) {
            gen.writeNull();
        } else {
            gen.writeStartObject();
            if (value.isInstant()) {
                gen.writeObjectField("start", (Object)value.asISO8601());
            } else {
                MomentInterval interval = value.getInterval().getInterval();
                Moment start = interval.getStartAsMoment();
                Moment end = interval.getEndAsMoment();
                gen.writeObjectField("start", (Object)StringHelper.FORMAT_MOMENT.print((Object)start));
                if (!start.equals((Object)end)) {
                    gen.writeObjectField("end", (Object)StringHelper.FORMAT_MOMENT.print((Object)end));
                }
            }
            gen.writeEndObject();
        }
    }
}

