/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlSchemaItem;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CsdlItemEntityContainer
implements CsdlSchemaItem {
    @JsonProperty(value="$Kind")
    public String kind = "EntityContainer";
    @JsonAnyGetter
    @JsonAnySetter
    public Map<String, ContainerItem> properties = new LinkedHashMap<String, ContainerItem>();

    public CsdlItemEntityContainer generateFrom(String nameSpace, CoreSettings settings) {
        for (EntityType et : settings.getModelRegistry().getEntityTypes(PrincipalExtended.getLocalPrincipal().isAdmin())) {
            this.properties.put(et.plural, new ContainerItem().generateFrom(nameSpace, et));
        }
        return this;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<EntityContainer Name=\"" + name + "\">");
        for (Map.Entry<String, ContainerItem> entry : this.properties.entrySet()) {
            String propName = entry.getKey();
            ContainerItem property = entry.getValue();
            property.writeXml(propName, writer);
        }
        writer.write("</EntityContainer>");
    }

    public static class ContainerItem {
        @JsonProperty(value="$Collection")
        @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
        public Boolean collection;
        @JsonProperty(value="$Type")
        public String type;
        @JsonProperty(value="$NavigationPropertyBinding")
        public Map<String, String> navPropBinding = new HashMap<String, String>();

        public ContainerItem generateFrom(String nameSpace, EntityType et) {
            this.collection = true;
            this.type = nameSpace + "." + et.entityName;
            for (NavigationPropertyMain np : et.getNavigationProperties()) {
                if (np.isAdminOnly() && !PrincipalExtended.getLocalPrincipal().isAdmin()) continue;
                this.navPropBinding.put(np.getName(), np.getEntityType().plural);
            }
            return this;
        }

        public void writeXml(String name, Writer writer) throws IOException {
            writer.write("<EntitySet Name=\"" + name + "\" EntityType=\"" + this.type + "\">");
            for (Map.Entry<String, String> entry : this.navPropBinding.entrySet()) {
                writer.write("<NavigationPropertyBinding Path=\"" + entry.getKey() + "\" Target=\"" + entry.getValue() + "\" />");
            }
            writer.write("</EntitySet>");
        }
    }
}

