/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.deserialize;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import java.text.ParseException;
import net.time4j.Moment;
import net.time4j.format.expert.Iso8601Format;

public class TimeValueDeserializer
extends StdDeserializer<TimeValue> {
    public TimeValueDeserializer() {
        super(TimeInterval.class);
    }

    public TimeValue deserialize(JsonParser parser, DeserializationContext dc) throws IOException {
        Moment start = null;
        Moment end = null;
        JsonToken currentToken = parser.nextToken();
        while (currentToken == JsonToken.FIELD_NAME) {
            String fieldName;
            switch (fieldName = parser.getCurrentName()) {
                case "start": {
                    start = TimeValueDeserializer.parseTime(parser);
                    break;
                }
                case "end": {
                    end = TimeValueDeserializer.parseTime(parser);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Found field " + fieldName + " expected one of: start, end");
                }
            }
            currentToken = parser.nextToken();
        }
        if (start == null && end == null) {
            return null;
        }
        if (start != null) {
            return TimeValue.create(start);
        }
        if (end != null) {
            return TimeValue.create(end);
        }
        return TimeValue.create(start, end);
    }

    public static Moment parseTime(JsonParser parser) throws IllegalArgumentException, IOException {
        parser.nextToken();
        String valueAsString = parser.getValueAsString();
        try {
            return (Moment)Iso8601Format.EXTENDED_DATE_TIME_OFFSET.parse((CharSequence)valueAsString);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Failed to parse TimeInstant " + StringHelper.cleanForLogging((String)valueAsString), ex);
        }
    }
}

