/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.fraunhofer.iosb.ilt.frostserver.json.mixin.MixinUtils;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.DateSerialiser;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntityChangedMessageSerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntityPropertySerialiser;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntitySerializer;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.EntityTypeSerialiser;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityChangedMessage;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntitySetResultOdata;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntitySetResultOdataSerializer;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntityWrapper;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntityWrapperSerializer;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.TimeInstantSerializer;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.TimeIntervalSerializer;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.TimeValueSerializer;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeSimplePrimitive;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;

public class JsonWriterOdata40 {
    public static final String AT_CONTEXT = "@odata.context";
    public static final String AT_COUNT = "@odata.count";
    public static final String AT_ID = "@odata.id";
    public static final String AT_NAVIGATION_LINK = "@odata.navigationLink";
    public static final String AT_NEXT_LINK = "@odata.nextLink";
    private static ObjectMapper objectMapperInstance;

    private JsonWriterOdata40() {
    }

    public static ObjectMapper getObjectMapper() {
        if (objectMapperInstance == null) {
            JsonWriterOdata40.initObjectMapper();
        }
        return objectMapperInstance;
    }

    private static synchronized void initObjectMapper() {
        if (objectMapperInstance == null) {
            objectMapperInstance = JsonWriterOdata40.createObjectMapper();
        }
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.disable(SerializationFeature.FLUSH_AFTER_WRITE_VALUE);
        MixinUtils.addMixins((ObjectMapper)mapper);
        SimpleModule module = new SimpleModule();
        module.addSerializer(EntityWrapper.class, (JsonSerializer)new EntityWrapperSerializer(AT_CONTEXT, AT_COUNT, AT_NAVIGATION_LINK, AT_NEXT_LINK, AT_ID));
        EntitySerializer entitySerializer = new EntitySerializer(true, AT_COUNT, AT_NAVIGATION_LINK, AT_NEXT_LINK, AT_ID);
        entitySerializer.addPropertyTypeSerializer((PropertyType)TypeSimplePrimitive.EDM_UNTYPED, (ep, entity, gen) -> {
            Object value = entity.getProperty((Property)ep);
            if (value != null || ep.serialiseNull) {
                gen.writeStringField(ep.name, mapper.writeValueAsString(value));
            }
        });
        module.addSerializer(Entity.class, (JsonSerializer)entitySerializer);
        module.addSerializer(EntityChangedMessage.class, (JsonSerializer)new EntityChangedMessageSerializer());
        module.addSerializer(EntitySetResultOdata.class, (JsonSerializer)new EntitySetResultOdataSerializer(AT_CONTEXT, AT_COUNT, AT_NEXT_LINK));
        module.addSerializer(TimeValue.class, (JsonSerializer)new TimeValueSerializer());
        module.addSerializer(TimeInstant.class, (JsonSerializer)new TimeInstantSerializer());
        module.addSerializer(TimeInterval.class, (JsonSerializer)new TimeIntervalSerializer());
        module.addSerializer(EntityType.class, (JsonSerializer)new EntityTypeSerialiser());
        module.addSerializer(Property.class, (JsonSerializer)new EntityPropertySerialiser());
        module.addSerializer(Date.class, (JsonSerializer)new DateSerialiser());
        mapper.registerModule((Module)module);
        return mapper;
    }

    public static void writeEntity(Writer writer, EntityWrapper entity) throws IOException {
        JsonWriterOdata40.getObjectMapper().writeValue(writer, (Object)entity);
    }

    public static void writeEntityCollection(Writer writer, EntitySetResultOdata entityCollection) throws IOException {
        JsonWriterOdata40.getObjectMapper().writeValue(writer, (Object)entityCollection);
    }

    public static void writeObject(Writer writer, Object object) throws IOException {
        JsonWriterOdata40.getObjectMapper().writeValue(writer, object);
    }

    public static String writeObject(Object object) throws IOException {
        return JsonWriterOdata40.getObjectMapper().writeValueAsString(object);
    }
}

