/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata;

import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriter;
import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriterGeneric;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatterEmpty;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntitySetResultOdata;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.EntityWrapper;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.JsonWriterOdata40;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.serialize.JsonWriterOdata401;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginResultFormat;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.geojson.GeoJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginResultFormatOData
implements PluginResultFormat {
    public static final String FORMAT_NAME_ODATA = "ODATA-JSON";
    private CoreSettings settings;

    public void init(CoreSettings settings) {
        this.settings = settings;
        settings.getPluginManager().registerPlugin((Plugin)this);
    }

    public boolean isEnabled() {
        return true;
    }

    public Collection<Version> getVersions() {
        return Arrays.asList(PluginOData.VERSION_ODATA_40, PluginOData.VERSION_ODATA_401);
    }

    public Collection<String> getFormatNames() {
        return Arrays.asList("default", FORMAT_NAME_ODATA, "noResponse");
    }

    public ResultFormatter getResultFormatter(String format) {
        if ("noResponse".equalsIgnoreCase(format)) {
            return new ResultFormatterEmpty();
        }
        return new ResultFormatterOData(this.settings);
    }

    public static class ResultFormatterOData
    implements ResultFormatter {
        private static final Logger LOGGER = LoggerFactory.getLogger(ResultFormatterOData.class);
        public final CoreSettings settings;

        public ResultFormatterOData(CoreSettings settings) {
            LOGGER.trace("Creating a new resultFormatter.");
            this.settings = settings;
        }

        public FormatWriter format(ResourcePath path, Query query, Object result, boolean useAbsoluteNavigationLinks) {
            try {
                Version version = path.getVersion();
                String contextBase = this.settings.getQueryDefaults().getServiceRootUrl() + "/" + version.urlPart + "/$metadata";
                if (Entity.class.isAssignableFrom(result.getClass())) {
                    return this.formatAsEntity(result, contextBase, version);
                }
                if (EntitySet.class.isAssignableFrom(result.getClass())) {
                    return this.formatAsEntitySet(result, contextBase, version, query);
                }
                String entityJsonString = "";
                if (path.isValue()) {
                    LOGGER.trace("Formatting as $Value.");
                    entityJsonString = result instanceof Map || result instanceof GeoJsonObject ? JsonWriterOdata401.writeObject(result) : (result instanceof Id ? ((Id)result).getValue().toString() : result.toString());
                } else {
                    LOGGER.trace("Formatting as Object.");
                    entityJsonString = JsonWriterOdata401.writeObject(result);
                }
                return new FormatWriterGeneric(entityJsonString);
            }
            catch (IOException ex) {
                LOGGER.error("Failed to format response.", (Throwable)ex);
                return null;
            }
        }

        private FormatWriter formatAsEntity(Object result, String contextBase, Version version) {
            LOGGER.trace("Formatting as Entity.");
            Entity entity = (Entity)result;
            EntityWrapper wrappedEntity = new EntityWrapper().setEntity(entity).setContext(contextBase + "#" + entity.getEntityType().plural + "/$entity");
            if (version == PluginOData.VERSION_ODATA_40) {
                return target -> JsonWriterOdata40.writeEntity(target, wrappedEntity);
            }
            return target -> JsonWriterOdata401.writeEntity(target, wrappedEntity);
        }

        private FormatWriter formatAsEntitySet(Object result, String contextBase, Version version, Query query) {
            LOGGER.trace("Formatting as EntitySet.");
            EntitySet entitySet = (EntitySet)result;
            EntitySetResultOdata wrappedSet = new EntitySetResultOdata(entitySet, query).setContext(contextBase + "#" + entitySet.getEntityType().plural);
            if (version == PluginOData.VERSION_ODATA_40) {
                return target -> JsonWriterOdata40.writeEntityCollection(target, wrappedSet);
            }
            return target -> JsonWriterOdata401.writeEntityCollection(target, wrappedSet);
        }

        public String getContentType() {
            return "application/json";
        }
    }
}

