/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.annotations.Annotation;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlAnnotation;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlPropertyEntity;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlPropertyNavigation;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlSchemaItem;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CsdlItemEntityType
implements CsdlSchemaItem {
    @JsonProperty(value="$Kind")
    public String kind = "EntityType";
    @JsonProperty(value="$Key")
    public List<String> key = new ArrayList<String>();
    @JsonIgnore
    public Map<String, CsdlProperty> properties = new LinkedHashMap<String, CsdlProperty>();
    @JsonIgnore
    private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

    public CsdlItemEntityType generateFrom(CsdlDocument doc, Version version, String nameSpace, EntityType et) {
        String keyName = et.getPrimaryKey().name;
        if ("@iot.id".equals(keyName)) {
            keyName = "id";
        }
        this.key.add(keyName);
        for (EntityPropertyMain ep : et.getEntityProperties()) {
            if (ep == ModelRegistry.EP_SELFLINK) continue;
            String propertyName = ep.getJsonName();
            if ("@iot.id".equals(propertyName)) {
                propertyName = "id";
            }
            this.properties.put(propertyName, new CsdlPropertyEntity().generateFrom(doc, version, nameSpace, et, ep));
        }
        for (NavigationPropertyMain np : et.getNavigationProperties()) {
            this.properties.put(np.getJsonName(), new CsdlPropertyNavigation().generateFrom(doc, nameSpace, et, np));
        }
        for (Annotation an : et.getAnnotations()) {
            this.annotations.add(new CsdlAnnotation().generateFrom(doc, an));
        }
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> otherProperties() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, CsdlProperty> entry : this.properties.entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        for (CsdlAnnotation annotation : this.annotations) {
            result.put("@" + annotation.getQualifiedName(), annotation.getValue());
        }
        return result;
    }

    @Override
    public void writeXml(String nameSpace, String name, Writer writer) throws IOException {
        writer.write("<EntityType Name=\"" + name + "\">");
        writer.write("<Key>");
        for (String string : this.key) {
            writer.write("<PropertyRef Name=\"" + string + "\" />");
        }
        writer.write("</Key>");
        for (Map.Entry entry : this.properties.entrySet()) {
            String propName = (String)entry.getKey();
            CsdlProperty property = (CsdlProperty)entry.getValue();
            property.writeXml(nameSpace, propName, writer);
        }
        for (CsdlAnnotation csdlAnnotation : this.annotations) {
            csdlAnnotation.writeXml(writer);
        }
        writer.write("</EntityType>");
    }
}

