/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.PluginOData;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlAnnotation;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlSchema;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;

public class CsdlDocument {
    @JsonProperty(value="$Version")
    public String version = "4.01";
    @JsonProperty(value="$EntityContainer")
    public String entityContainer = "de.FROST.FrostService";
    @JsonAnyGetter
    @JsonAnySetter
    public Map<String, CsdlSchema> nameSpaces = new LinkedHashMap<String, CsdlSchema>();
    @JsonProperty(value="$Reference")
    private final Map<String, ReferencedDoc> referencedDocs = new TreeMap<String, ReferencedDoc>();

    public CsdlDocument generateFrom(Version version, CoreSettings settings) {
        this.version = version == PluginOData.VERSION_ODATA_40 ? "4.0" : "4.01";
        String nameSpace = "de.FROST";
        this.nameSpaces.put(nameSpace, new CsdlSchema().generateFrom(this, version, nameSpace, settings));
        return this;
    }

    public void registerAnnotation(String baseUrl, CsdlAnnotation annotation) {
        this.referencedDocs.computeIfAbsent(baseUrl, ReferencedDoc::new).addAnnotation(annotation);
    }

    public void writeXml(Version version, Writer writer) throws IOException {
        if (version == PluginOData.VERSION_ODATA_40) {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?><edmx:Edmx Version=\"4.0\" xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\">");
        } else {
            writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?><edmx:Edmx Version=\"4.01\" xmlns:edmx=\"http://docs.oasis-open.org/odata/ns/edmx\">");
        }
        for (ReferencedDoc referencedDoc : this.referencedDocs.values()) {
            referencedDoc.writeXml(writer);
        }
        writer.write("<edmx:DataServices>");
        for (Map.Entry entry : this.nameSpaces.entrySet()) {
            String name = (String)entry.getKey();
            CsdlSchema schema = (CsdlSchema)entry.getValue();
            schema.writeXml(name, writer);
        }
        writer.write("</edmx:DataServices></edmx:Edmx>");
    }

    private static class ReferencedNamespace {
        @JsonProperty(value="$Namespace")
        private final String namespace;
        @JsonProperty(value="$Alias")
        private String alias;
        @JsonIgnore
        private final List<CsdlAnnotation> annotations = new ArrayList<CsdlAnnotation>();

        public ReferencedNamespace(String name) {
            this.namespace = name;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public String getAlias() {
            return this.alias;
        }

        public ReferencedNamespace setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public List<CsdlAnnotation> getAnnotations() {
            return this.annotations;
        }

        public ReferencedNamespace addAnnotation(CsdlAnnotation annotation) {
            this.annotations.add(annotation);
            annotation.setNamespace(this.alias);
            return this;
        }

        public void writeXml(Writer writer) throws IOException {
            writer.write("<edmx:Include Alias=\"" + this.alias + "\" Namespace=\"" + this.namespace + "\" />");
        }
    }

    private static class ReferencedDoc {
        @JsonProperty(value="$Include")
        private final List<ReferencedNamespace> includes = new ArrayList<ReferencedNamespace>();
        @JsonIgnore
        private final String url;
        @JsonIgnore
        private final Map<String, ReferencedNamespace> namespaces = new TreeMap<String, ReferencedNamespace>();
        @JsonIgnore
        private final Set<String> aliases = new TreeSet<String>();

        public ReferencedDoc(String url) {
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public ReferencedDoc addAnnotation(CsdlAnnotation annotation) {
            ReferencedNamespace refNs = this.namespaces.computeIfAbsent(annotation.getNamespace(), this::createReferencedNamespace);
            refNs.addAnnotation(annotation);
            return this;
        }

        public List<ReferencedNamespace> getIncludes() {
            return this.includes;
        }

        private ReferencedNamespace createReferencedNamespace(String namespace) {
            String[] parts = StringUtils.split((String)namespace, (char)'.');
            String baseAlias = parts[parts.length - 2];
            int i = 1;
            Object alias = baseAlias;
            while (this.aliases.contains(alias)) {
                alias = baseAlias + i++;
            }
            ReferencedNamespace refNs = new ReferencedNamespace(namespace).setAlias((String)alias);
            this.aliases.add((String)alias);
            this.includes.add(refNs);
            return refNs;
        }

        public void writeXml(Writer writer) throws IOException {
            String xmlUrl = this.url.replace(".json", ".xml");
            writer.write("<edmx:Reference Uri=\"" + xmlUrl + "\">");
            for (ReferencedNamespace include : this.includes) {
                include.writeXml(writer);
            }
            writer.write("</edmx:Reference>");
        }
    }
}

