/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.odata;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.odata.metadata.CsdlDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)MetaDataGenerator.class.getName());
    private final CoreSettings settings;

    public MetaDataGenerator(CoreSettings settings) {
        this.settings = settings;
    }

    public ServiceResponse generateMetaData(ServiceRequest request, ServiceResponse response) {
        Version version = request.getVersion();
        try {
            CsdlDocument doc = new CsdlDocument().generateFrom(version, this.settings);
            String format = request.getParameter("$format", "");
            String accept = request.getParameter("Accept");
            int idxXml = accept.indexOf("application/xml");
            int idxJson = accept.indexOf("application/json");
            if (idxXml == -1) {
                idxXml = Integer.MAX_VALUE;
            }
            if (idxJson == -1) {
                idxJson = Integer.MAX_VALUE;
            }
            if (idxJson < idxXml || "json".equalsIgnoreCase(format)) {
                response.setContentType("application/json");
                SimpleJsonMapper.getSimpleObjectMapper().writeValue(response.getWriter(), (Object)doc);
                response.setCode(200);
            } else {
                response.setContentType("application/xml");
                doc.writeXml(version, response.getWriter());
                response.setCode(200);
            }
        }
        catch (IOException ex) {
            LOGGER.error("Failed to generate metadata document", (Throwable)ex);
        }
        return response;
    }
}

