/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools;

import de.fraunhofer.iosb.ilt.frostserver.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjEntityEntry;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjRowCollector;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import java.util.Map;
import java.util.TreeMap;

public class GjComplexProperty
implements GjEntityEntry {
    private final String name;
    private final EntityProperty property;
    private final Map<String, String> subProperties = new TreeMap<String, String>();

    public GjComplexProperty(String name, EntityProperty property) {
        this.name = name;
        this.property = property;
        TypeComplex type = (TypeComplex)property.getType();
        for (Map.Entry subProperty : type.getPropertiesByName().entrySet()) {
            String subName = (String)subProperty.getKey();
            this.subProperties.put(name + "/" + subName, subName);
        }
    }

    @Override
    public void writeData(GjRowCollector collector, Entity source, String namePrefix) {
        Object value = source.getProperty((Property)this.property);
        if (value instanceof ComplexValue) {
            ComplexValue complexValue = (ComplexValue)value;
            for (Map.Entry<String, String> entry : this.subProperties.entrySet()) {
                collector.collectEntry(namePrefix + entry.getKey(), complexValue.getProperty(entry.getValue()), null);
            }
        } else if (value instanceof Map) {
            Map mapValue = (Map)value;
            for (Map.Entry<String, String> entry : this.subProperties.entrySet()) {
                collector.collectEntry(namePrefix + entry.getKey(), mapValue.get(entry.getValue()), null);
            }
        } else {
            collector.collectEntry(namePrefix + this.name, this.property.getFrom(source), null);
        }
    }
}

