/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geojson.Feature;
import org.geojson.GeoJsonObject;

public class GjRowCollector {
    private final Map<String, Object> collection = new LinkedHashMap<String, Object>();
    private final FeatureList features = new FeatureList();
    private Feature feature;

    public GjRowCollector() {
        this.collection.put("type", "FeatureCollection");
        this.collection.put("@iot.nextLink", null);
        this.collection.put("@iot.count", null);
        this.collection.put("features", this.features);
        this.newFeature();
    }

    public Map<String, Object> getCollection() {
        return this.collection;
    }

    public void setNextLink(String nextLink) {
        this.collection.put("@iot.nextLink", nextLink);
    }

    public void setCount(Long count) {
        if (count >= 0L) {
            this.collection.put("@iot.count", count);
        }
    }

    private void newFeature() {
        this.feature = new Feature();
        this.feature.setProperties(new LinkedHashMap());
    }

    public void collectEntry(String headerName, Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Feature) {
            Feature featureValue = (Feature)value;
            this.feature.setGeometry(featureValue.getGeometry());
            this.feature.getProperties().putAll(featureValue.getProperties());
            return;
        }
        if (value instanceof TimeValue) {
            if (!((TimeValue)value).isEmpty()) {
                this.feature.setProperty(headerName, value);
            }
            return;
        }
        if (value instanceof GeoJsonObject) {
            if (this.feature.getGeometry() == null) {
                this.feature.setGeometry((GeoJsonObject)value);
            }
            return;
        }
        if (value instanceof Map) {
            this.flattenMap((Map)value, headerName);
            return;
        }
        if (value instanceof List) {
            this.flattenList((List)value, headerName);
            return;
        }
        if (value instanceof Entity) {
            return;
        }
        this.feature.setProperty(headerName, value);
    }

    private void flattenMap(Map<String, Object> map, String headerName) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            String header = headerName + "/" + key;
            Object value = entry.getValue();
            this.collectEntry(header, value);
        }
    }

    private void flattenList(List<Object> list, String headerName) {
        int idx = 0;
        for (Object item : list) {
            String header = headerName + "/" + idx;
            this.collectEntry(header, item);
            ++idx;
        }
    }

    public void flush() {
        this.features.add(this.feature);
        this.newFeature();
    }

    private static class FeatureList
    extends ArrayList<GeoJsonObject> {
        private FeatureList() {
        }
    }
}

