/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjComplexProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjEntityEntry;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjEntityExpand;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjRowCollector;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjSelfLinkProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GjElementSet {
    private final String name;
    private final List<GjEntityEntry> elements = new ArrayList<GjEntityEntry>();
    private final boolean topLevel;
    private final String serviceRootUrl;
    private final Version version;
    private final Query query;

    public GjElementSet(Query query, String serviceRootUrl, Version version, String name, boolean flush) {
        this.query = query;
        this.serviceRootUrl = serviceRootUrl;
        this.version = version;
        this.name = name;
        this.topLevel = flush;
    }

    public void initFrom(EntityType type) {
        if (this.query == null || this.query.getSelect().isEmpty()) {
            this.initFrom(type.getPropertySet());
        } else {
            this.initFrom(this.query.getSelect());
        }
    }

    public void initFrom(Set<Property> properties) {
        this.initProperties(properties);
        if (this.query == null) {
            return;
        }
        for (Expand expand : this.query.getExpand()) {
            NavigationProperty path = expand.getPath();
            this.initFrom(path, expand.getSubQuery());
        }
    }

    private void initProperties(Set<Property> properties) {
        for (Property property : properties) {
            if (property == ModelRegistry.EP_SELFLINK) {
                this.elements.add(new GjSelfLinkProperty(this.query, this.serviceRootUrl, this.version, ModelRegistry.EP_SELFLINK.name));
            }
            if (property instanceof EntityPropertyMain) {
                this.initFrom((EntityPropertyMain)property);
                continue;
            }
            if (!(property instanceof EntityPropertyCustomSelect)) continue;
            this.elements.add(new GjEntityProperty(((EntityPropertyCustomSelect)property).getName(), property));
        }
    }

    private void initFrom(EntityPropertyMain property) {
        PropertyType type = property.getType();
        if (type instanceof TypeComplex && !((TypeComplex)type).isOpenType()) {
            this.elements.add(new GjComplexProperty(property.name, (EntityProperty)property));
        } else {
            this.elements.add(new GjEntityProperty(property.name, (Property)property));
        }
    }

    public void initFrom(NavigationProperty property, Query query) {
        GjEntityExpand element = new GjEntityExpand(this.serviceRootUrl, this.version, property.getName() + "/", property, query);
        this.elements.add(element);
    }

    public void writeData(GjRowCollector collector, Object obj, String namePrefix) {
        if (obj instanceof Entity) {
            this.writeData(collector, (Entity)obj, namePrefix + this.name);
        } else if (obj instanceof EntitySet) {
            this.writeData(collector, (EntitySet)obj, namePrefix + this.name);
        }
    }

    public void writeData(GjRowCollector collector, Entity entity, String namePrefix) {
        if (entity == null) {
            return;
        }
        this.collectElements(collector, entity, namePrefix);
        if (this.topLevel) {
            collector.flush();
        }
    }

    public void writeData(GjRowCollector collector, EntitySet entitySet, String namePrefix) {
        if (entitySet == null) {
            return;
        }
        int idx = 0;
        if (this.topLevel) {
            collector.setNextLink(entitySet.getNextLink());
            collector.setCount(entitySet.getCount());
        }
        for (Entity entity : entitySet) {
            String localName = this.topLevel ? namePrefix : namePrefix + idx + "/";
            this.collectElements(collector, entity, localName);
            if (this.topLevel) {
                collector.flush();
            }
            ++idx;
        }
    }

    private void collectElements(GjRowCollector collector, Entity entity, String namePrefix) {
        for (GjEntityEntry element : this.elements) {
            element.writeData(collector, entity, namePrefix);
        }
    }
}

