/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjEntityEntry;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjEntityExpand;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjRowCollector;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjSelfLinkProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.geojson.tools.GjUnitOfMeasurementProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GjElementSet {
    private final String name;
    private final List<GjEntityEntry> elements = new ArrayList<GjEntityEntry>();
    private final boolean flush;
    private final String serviceRootUrl;
    private final Version version;

    public GjElementSet(String serviceRootUrl, Version version, String name, boolean flush) {
        this.serviceRootUrl = serviceRootUrl;
        this.version = version;
        this.name = name;
        this.flush = flush;
    }

    public void initFrom(EntityType type, Query query) {
        if (query == null || query.getSelect().isEmpty()) {
            this.initFrom(type.getPropertySet(), query);
        } else {
            this.initFrom(query.getSelect(), query);
        }
    }

    public void initFrom(Set<Property> properties, Query query) {
        this.initProperties(properties);
        if (query == null) {
            return;
        }
        for (Expand expand : query.getExpand()) {
            NavigationProperty path = expand.getPath();
            this.initFrom(path, expand.getSubQuery());
        }
    }

    private void initProperties(Set<Property> properties) {
        for (Property property : properties) {
            if (property == EntityPropertyMain.SELFLINK) {
                this.elements.add(new GjSelfLinkProperty(this.serviceRootUrl, this.version, EntityPropertyMain.SELFLINK.entitiyName));
            }
            if (property == EntityPropertyMain.UNITOFMEASUREMENT) {
                this.elements.add(new GjUnitOfMeasurementProperty(EntityPropertyMain.UNITOFMEASUREMENT.entitiyName));
                continue;
            }
            if (property instanceof EntityPropertyMain) {
                this.elements.add(new GjEntityProperty(((EntityPropertyMain)property).entitiyName, property));
                continue;
            }
            if (!(property instanceof EntityPropertyCustomSelect)) continue;
            this.elements.add(new GjEntityProperty(((EntityPropertyCustomSelect)property).getName(), property));
        }
    }

    public void initFrom(NavigationProperty property, Query query) {
        GjEntityExpand element = new GjEntityExpand(this.serviceRootUrl, this.version, property.getName() + "/", property, query);
        this.elements.add(element);
    }

    public void writeData(GjRowCollector collector, Object obj, String namePrefix) {
        if (obj instanceof Entity) {
            this.writeData(collector, (Entity)obj, namePrefix + this.name);
        } else if (obj instanceof EntitySet) {
            this.writeData(collector, (EntitySet)obj, namePrefix + this.name);
        }
    }

    public void writeData(GjRowCollector collector, Entity<?> entity, String namePrefix) {
        if (entity == null) {
            return;
        }
        this.collectElements(collector, entity, namePrefix);
        if (this.flush) {
            collector.flush();
        }
    }

    public void writeData(GjRowCollector collector, EntitySet<?> entitySet, String namePrefix) {
        if (entitySet == null) {
            return;
        }
        List list = entitySet.asList();
        int idx = 0;
        for (Entity entity : list) {
            String localName = this.flush ? namePrefix : namePrefix + idx + "/";
            this.collectElements(collector, entity, localName);
            if (this.flush) {
                collector.flush();
            }
            ++idx;
        }
    }

    private void collectElements(GjRowCollector collector, Entity<?> entity, String namePrefix) {
        for (GjEntityEntry element : this.elements) {
            element.writeData(collector, entity, namePrefix);
        }
    }
}

