/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.custom.CustomEntityDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayValue;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataArrayDeserializer
extends JsonDeserializer<List<DataArrayValue>> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DataArrayDeserializer.class.getName());
    private static final TypeReference<List<List<Object>>> LIST_LIST_OBJECT = new TypeReference<List<List<Object>>>(){};
    private final ModelRegistry modelRegistry;
    private final PluginCoreModel pluginCoreModel;
    private final EntityType etMultiDatastream;

    public DataArrayDeserializer(CoreSettings settings) {
        this.modelRegistry = settings.getModelRegistry();
        this.pluginCoreModel = (PluginCoreModel)settings.getPluginManager().getPlugin(PluginCoreModel.class);
        this.etMultiDatastream = this.modelRegistry.getEntityTypeForName("MultiDatastream");
    }

    public static List<DataArrayValue> deserialize(String value, JsonReader reader, CoreSettings settings) throws IOException {
        ObjectMapper mapper = reader.getMapper();
        try (JsonParser parser = mapper.createParser(value);){
            DefaultDeserializationContext dsc = (DefaultDeserializationContext)mapper.getDeserializationContext();
            dsc = dsc.createInstance(mapper.getDeserializationConfig(), parser, mapper.getInjectableValues());
            Object object = new DataArrayDeserializer(settings).deserialize(parser, (DeserializationContext)dsc);
            return object;
        }
    }

    public static List<DataArrayValue> deserialize(Reader value, JsonReader reader, CoreSettings settings) throws IOException {
        ObjectMapper mapper = reader.getMapper();
        try (JsonParser parser = mapper.createParser(value);){
            DefaultDeserializationContext dsc = (DefaultDeserializationContext)mapper.getDeserializationContext();
            dsc = dsc.createInstance(mapper.getDeserializationConfig(), parser, mapper.getInjectableValues());
            Object object = new DataArrayDeserializer(settings).deserialize(parser, (DeserializationContext)dsc);
            return object;
        }
    }

    public List<DataArrayValue> deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ArrayList<DataArrayValue> result = new ArrayList<DataArrayValue>();
        JsonToken currentToken = parser.nextToken();
        DataArrayDeserializer.expect(JsonToken.START_ARRAY, currentToken);
        currentToken = parser.nextToken();
        while (currentToken == JsonToken.START_OBJECT) {
            result.add(this.deserializeDataArrayValue(parser, ctxt));
            currentToken = parser.nextToken();
        }
        return result;
    }

    private DataArrayValue deserializeDataArrayValue(JsonParser parser, DeserializationContext ctxt) throws IOException {
        DataArrayValue result = new DataArrayValue();
        JsonToken currentToken = parser.nextToken();
        while (currentToken == JsonToken.FIELD_NAME) {
            String fieldName;
            switch (fieldName = parser.getCurrentName()) {
                case "Datastream": {
                    parser.nextToken();
                    result.setDatastream(CustomEntityDeserializer.getInstance((ModelRegistry)this.modelRegistry, (EntityType)this.pluginCoreModel.etDatastream).deserialize(parser, ctxt));
                    break;
                }
                case "MultiDatastream": {
                    if (this.etMultiDatastream == null) {
                        throw new IllegalArgumentException("MultiDatastream plugin not enabled.");
                    }
                    parser.nextToken();
                    result.setMultiDatastream(CustomEntityDeserializer.getInstance((ModelRegistry)this.modelRegistry, (EntityType)this.etMultiDatastream).deserialize(parser, ctxt));
                    break;
                }
                case "components": {
                    currentToken = parser.nextToken();
                    DataArrayDeserializer.expect(JsonToken.START_ARRAY, currentToken);
                    currentToken = parser.nextToken();
                    while (currentToken == JsonToken.VALUE_STRING) {
                        String componentName = parser.getValueAsString();
                        result.getComponents().add(componentName);
                        currentToken = parser.nextToken();
                    }
                    break;
                }
                case "dataArray": {
                    parser.nextToken();
                    result.setDataArray((List)parser.readValueAs(LIST_LIST_OBJECT));
                    break;
                }
                case "dataArray@iot.count": {
                    parser.nextToken();
                    break;
                }
                default: {
                    LOGGER.warn("Unknown field in message: {}", (Object)fieldName);
                }
            }
            currentToken = parser.nextToken();
        }
        return result;
    }

    private static void expect(JsonToken expected, JsonToken value) {
        if (value != expected) {
            throw new IllegalArgumentException("Expected token " + expected + ". Found: " + value);
        }
    }
}

