/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayResult;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayValue;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.ResultFormatterDataArray;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.ServiceDataArray;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.json.DataArrayResultSerializer;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.json.DataArrayValueSerializer;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginResultFormat;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PluginResultFormatDataArray
implements PluginResultFormat,
PluginService,
PluginRootDocument,
ConfigDefaults {
    @DefaultValueBoolean(value=true)
    public static final String TAG_ENABLE_DATA_ARRAY = "dataArray.enable";
    private static final String REQUIREMENT_DATA_ARRAY = "http://www.opengis.net/spec/iot_sensing/1.1/req/data-array/data-array";
    public static final String DATA_ARRAY_FORMAT_NAME = "dataArray";
    private static boolean modifiedEntityFormatter = false;
    private CoreSettings settings;
    private boolean enabled;

    public void init(CoreSettings settings) {
        this.settings = settings;
        Settings pluginSettings = settings.getPluginSettings();
        this.enabled = pluginSettings.getBoolean(TAG_ENABLE_DATA_ARRAY, this.getClass());
        if (this.enabled) {
            settings.getPluginManager().registerPlugin((Plugin)this);
            PluginResultFormatDataArray.modifyEntityFormatter();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Collection<String> getFormatNames() {
        return Arrays.asList(DATA_ARRAY_FORMAT_NAME);
    }

    public ResultFormatter getResultFormatter(String format) {
        return new ResultFormatterDataArray(this.settings);
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        Map serverSettings = (Map)result.get("serverSettings");
        if (serverSettings == null) {
            return;
        }
        Set extensionList = (Set)serverSettings.get("conformance");
        extensionList.add(REQUIREMENT_DATA_ARRAY);
    }

    public Collection<Version> getVersions() {
        return Arrays.asList(Version.V_1_0, Version.V_1_1);
    }

    public Collection<String> getVersionedUrlPaths() {
        return Arrays.asList("/CreateObservations");
    }

    public Collection<String> getRequestTypes() {
        return Arrays.asList("createObservations");
    }

    public String getRequestTypeFor(Version version, String path, HttpMethod method, String contentType) {
        if (HttpMethod.POST.equals((Object)method) && "/CreateObservations".equals(path)) {
            return "createObservations";
        }
        throw new IllegalArgumentException("Method " + method + "not valid for path " + path);
    }

    public ServiceResponse execute(Service service, ServiceRequest request, ServiceResponse response) {
        return new ServiceDataArray(this.settings).executeCreateObservations(service, request, response);
    }

    public static void modifyEntityFormatter() {
        if (modifiedEntityFormatter) {
            return;
        }
        modifiedEntityFormatter = true;
        SimpleModule module = new SimpleModule();
        module.addSerializer(DataArrayValue.class, (JsonSerializer)new DataArrayValueSerializer());
        module.addSerializer(DataArrayResult.class, (JsonSerializer)new DataArrayResultSerializer());
        JsonWriter.getObjectMapper().registerModule((Module)module);
    }
}

