/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReaderDefault;
import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.parser.query.QueryParser;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.ArrayValueHandlers;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayValue;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.json.DataArrayDeserializer;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Metadata;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDataArray {
    public static final String PATH_CREATE_OBSERVATIONS = "/CreateObservations";
    public static final String REQUEST_TYPE_CREATE_OBSERVATIONS = "createObservations";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceDataArray.class);
    private final CoreSettings settings;
    private final PluginCoreModel pluginCoreModel;
    private final ArrayValueHandlers arrayValueHandlers;
    private final NavigationPropertyMain.NavigationPropertyEntity npMultiDatastream;

    public ServiceDataArray(CoreSettings settings) {
        this.settings = settings;
        this.pluginCoreModel = (PluginCoreModel)settings.getPluginManager().getPlugin(PluginCoreModel.class);
        this.npMultiDatastream = (NavigationPropertyMain.NavigationPropertyEntity)settings.getModelRegistry().getEntityTypeForName("Observation").getNavigationProperty("MultiDatastream");
        this.arrayValueHandlers = new ArrayValueHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse executeCreateObservations(Service service, ServiceRequest request, ServiceResponse response) {
        Version version = request.getVersion();
        PersistenceManager pm = service.getPm();
        try {
            Query query = QueryParser.parseQuery((String)request.getUrlQuery(), (CoreSettings)this.settings, null, (PrincipalExtended)request.getUserPrincipal());
            JsonReaderDefault entityParser = new JsonReaderDefault(this.settings.getModelRegistry(), request.getUserPrincipal());
            List<DataArrayValue> postData = DataArrayDeserializer.deserialize(request.getContentReader(), (JsonReader)entityParser, this.settings);
            ArrayList<String> selfLinks = new ArrayList<String>();
            for (DataArrayValue daValue : postData) {
                Entity datastream = daValue.getDatastream();
                Entity multiDatastream = daValue.getMultiDatastream();
                ArrayList<ArrayValueHandlers.ArrayValueHandler> handlers = new ArrayList<ArrayValueHandlers.ArrayValueHandler>();
                for (String component : daValue.getComponents()) {
                    handlers.add(this.arrayValueHandlers.getHandler(this.settings, component));
                }
                this.handleDataArrayItems(query, version, handlers, daValue, datastream, multiDatastream, pm, selfLinks);
            }
            service.maybeCommitAndClose();
            ResultFormatter formatter = this.settings.getFormatter(version, "default");
            response.setContentType(formatter.getContentType());
            formatter.format(null, query, selfLinks, this.settings.getQueryDefaults().useAbsoluteNavigationLinks()).writeFormatted(response.getWriter());
            ServiceResponse serviceResponse = Service.successResponse((ServiceResponse)response, (int)201, (String)"Created");
            return serviceResponse;
        }
        catch (IOException | IllegalArgumentException e) {
            pm.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse((ServiceResponse)response, (int)400, (String)e.getMessage());
            return serviceResponse;
        }
        catch (RuntimeException e) {
            pm.rollbackAndClose();
            LOGGER.error("CreateObservations failed.", (Throwable)e);
            ServiceResponse serviceResponse = Service.errorResponse((ServiceResponse)response, (int)500, (String)e.getMessage());
            return serviceResponse;
        }
        catch (IncorrectRequestException ex) {
            LOGGER.error("Formatter not available.", (Throwable)ex);
            ServiceResponse serviceResponse = Service.errorResponse((ServiceResponse)response, (int)500, (String)"Failed to instantiate formatter");
            return serviceResponse;
        }
        finally {
            service.maybeRollbackAndClose();
        }
    }

    private void handleDataArrayItems(Query query, Version version, List<ArrayValueHandlers.ArrayValueHandler> handlers, DataArrayValue daValue, Entity datastream, Entity multiDatastream, PersistenceManager pm, List<String> selfLinks) {
        String serviceRootUrl = this.settings.getQueryDefaults().getServiceRootUrl();
        int compCount = handlers.size();
        for (List<Object> entry : daValue.getDataArray()) {
            try {
                DefaultEntity observation = new DefaultEntity(this.pluginCoreModel.etObservation);
                if (datastream != null) {
                    observation.setProperty((Property)this.pluginCoreModel.npDatastreamObservation, (Object)datastream);
                } else {
                    if (this.npMultiDatastream == null) {
                        throw new IllegalArgumentException("No Datastream found and MultiDatastream plugin not enabled.");
                    }
                    observation.setProperty((Property)this.npMultiDatastream, (Object)multiDatastream);
                }
                for (int i = 0; i < compCount; ++i) {
                    handlers.get(i).handle(entry.get(i), (Entity)observation);
                }
                pm.insert((Entity)observation, UpdateMode.INSERT_STA_11);
                if (query.getMetadata() == Metadata.OFF) {
                    selfLinks.add("");
                    continue;
                }
                String selfLink = UrlHelper.generateSelfLink((String)serviceRootUrl, (Version)version, (Entity)observation);
                selfLinks.add(selfLink);
            }
            catch (IncompleteEntityException | NoSuchEntityException | IllegalArgumentException exc) {
                LOGGER.debug("Failed to create entity", exc);
                selfLinks.add("error " + exc.getMessage());
            }
        }
    }
}

