/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriter;
import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriterGeneric;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayResult;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayValue;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFormatterDataArray
implements ResultFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultFormatterDataArray.class);
    private static final String OBSERVATIONS_ONLY = "ResultFormat=dataArray is only valid for /Observations";
    private final PluginCoreModel pluginCoreModel;
    private NavigationPropertyMain.NavigationPropertyEntity npMultiDatastream;

    public ResultFormatterDataArray(CoreSettings settings) {
        this.pluginCoreModel = (PluginCoreModel)settings.getPluginManager().getPlugin(PluginCoreModel.class);
        LOGGER.debug("Creating a new ResultFormaterDataArray.");
    }

    public void preProcessRequest(ResourcePath path, Query query) throws IncorrectRequestException {
        PathElement lastElement;
        if (this.npMultiDatastream == null) {
            this.npMultiDatastream = (NavigationPropertyMain.NavigationPropertyEntity)this.pluginCoreModel.etObservation.getNavigationProperty("MultiDatastream");
        }
        if (!(path.getLastElement() instanceof PathElementEntitySet) || path.isRef()) {
            throw new IncorrectRequestException(OBSERVATIONS_ONLY);
        }
        if (!query.getSelect().isEmpty() && (lastElement = path.getLastElement()) instanceof PathElementEntitySet && ((PathElementEntitySet)lastElement).getEntityType() == this.pluginCoreModel.etObservation) {
            query.getSelect().add(this.pluginCoreModel.npDatastreamObservation);
            if (this.npMultiDatastream != null) {
                query.getSelect().add(this.npMultiDatastream);
            }
        }
    }

    public FormatWriter format(ResourcePath path, Query query, Object result, boolean useAbsoluteNavigationLinks) {
        try {
            EntitySet entitySet;
            if (EntitySet.class.isAssignableFrom(result.getClass()) && (entitySet = (EntitySet)result).getEntityType() == this.pluginCoreModel.etObservation) {
                return new FormatWriterGeneric(this.formatDataArray(path, query, entitySet));
            }
            throw new IllegalArgumentException(OBSERVATIONS_ONLY);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to format response.", (Throwable)ex);
            return null;
        }
    }

    public String getContentType() {
        return "application/json";
    }

    public String formatDataArray(ResourcePath path, Query query, EntitySet entitySet) throws IOException {
        VisibleComponents visComps = query == null || query.getSelect().isEmpty() ? new VisibleComponents(this.pluginCoreModel, true) : new VisibleComponents(this.pluginCoreModel, query.getSelect());
        List<String> components = visComps.getComponents();
        LinkedHashMap<String, DataArrayValue> dataArraySet = new LinkedHashMap<String, DataArrayValue>();
        for (Entity obs : entitySet) {
            String dataArrayId = DataArrayValue.dataArrayIdFor(obs, this.pluginCoreModel.npDatastreamObservation, this.npMultiDatastream);
            DataArrayValue dataArray = dataArraySet.computeIfAbsent(dataArrayId, k -> new DataArrayValue(query, path, obs, components, (NavigationPropertyMain<Entity>)this.pluginCoreModel.npDatastreamObservation, (NavigationPropertyMain<Entity>)this.npMultiDatastream));
            dataArray.getDataArray().add(visComps.fromObservation(obs));
        }
        DataArrayResult result = new DataArrayResult();
        List<DataArrayValue> values = result.getValue();
        for (DataArrayValue daValue : dataArraySet.values()) {
            values.add(daValue);
        }
        result.setCount(entitySet.getCount());
        result.setNextLink(entitySet.getNextLink());
        return JsonWriter.writeObject((Object)result);
    }

    public static class VisibleComponents {
        public final boolean id;
        public final boolean phenomenonTime;
        public final boolean result;
        public final boolean resultTime;
        public final boolean resultQuality;
        public final boolean validTime;
        public final boolean parameters;
        private final PluginCoreModel pluginCoreModel;

        public VisibleComponents(PluginCoreModel pCoreModel) {
            this(pCoreModel, false);
        }

        public VisibleComponents(PluginCoreModel pCoreModel, boolean allValue) {
            this.pluginCoreModel = pCoreModel;
            this.id = allValue;
            this.phenomenonTime = allValue;
            this.result = allValue;
            this.resultTime = allValue;
            this.resultQuality = allValue;
            this.validTime = allValue;
            this.parameters = allValue;
        }

        public VisibleComponents(PluginCoreModel pCoreModel, Set<Property> select) {
            this.pluginCoreModel = pCoreModel;
            this.id = select.contains(pCoreModel.etObservation.getPrimaryKey());
            this.phenomenonTime = select.contains(pCoreModel.epPhenomenonTime);
            this.result = select.contains(pCoreModel.epResult);
            this.resultTime = select.contains(pCoreModel.epResultTime);
            this.resultQuality = select.contains(pCoreModel.epResultQuality);
            this.validTime = select.contains(pCoreModel.epValidTime);
            this.parameters = select.contains(pCoreModel.epParameters);
        }

        public List<String> getComponents() {
            ArrayList<String> components = new ArrayList<String>();
            if (this.id) {
                components.add("id");
            }
            if (this.phenomenonTime) {
                components.add(this.pluginCoreModel.epPhenomenonTime.getName());
            }
            if (this.result) {
                components.add(this.pluginCoreModel.epResult.getName());
            }
            if (this.resultTime) {
                components.add(this.pluginCoreModel.epResultTime.getName());
            }
            if (this.resultQuality) {
                components.add(this.pluginCoreModel.epResultQuality.getName());
            }
            if (this.validTime) {
                components.add(this.pluginCoreModel.epValidTime.getName());
            }
            if (this.parameters) {
                components.add(this.pluginCoreModel.epParameters.getName());
            }
            return components;
        }

        public List<Object> fromObservation(Entity o) {
            ArrayList<Object> value = new ArrayList<Object>();
            if (this.id) {
                value.add(o.getId().getValue());
            }
            if (this.phenomenonTime) {
                value.add(o.getProperty((Property)this.pluginCoreModel.epPhenomenonTime));
            }
            if (this.result) {
                value.add(o.getProperty((Property)this.pluginCoreModel.epResult));
            }
            if (this.resultTime) {
                value.add(o.getProperty((Property)this.pluginCoreModel.epResultTime));
            }
            if (this.resultQuality) {
                value.add(o.getProperty((Property)this.pluginCoreModel.epResultQuality));
            }
            if (this.validTime) {
                value.add(o.getProperty((Property)this.pluginCoreModel.epValidTime));
            }
            if (this.parameters) {
                value.add(o.getProperty((Property)this.pluginCoreModel.epParameters));
            }
            return value;
        }
    }
}

