/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(value={"dataArray@iot.count"})
public class DataArrayValue {
    public static final TypeReference<List<DataArrayValue>> LIST_OF_DATAARRAYVALUE = new TypeReference<List<DataArrayValue>>(){};
    @JsonProperty(value="Datastream")
    private Entity datastream;
    @JsonProperty(value="MultiDatastream")
    private Entity multiDatastream;
    private List<String> components;
    private List<List<Object>> dataArray = new ArrayList<List<Object>>();

    public DataArrayValue() {
        this.components = new ArrayList<String>();
    }

    public DataArrayValue(Entity parentEntitiy, List<String> components, EntityType datastream) {
        if (parentEntitiy.getEntityType() == datastream) {
            this.datastream = parentEntitiy;
        } else {
            this.multiDatastream = parentEntitiy;
        }
        this.components = components;
    }

    public DataArrayValue(Query query, ResourcePath path, Entity observation, List<String> components, NavigationPropertyMain<Entity> npDatastream, NavigationPropertyMain<Entity> npMultiDatastream) {
        this.datastream = (Entity)observation.getProperty(npDatastream);
        this.components = components;
        if (this.datastream != null) {
            this.datastream.setSelfLink(UrlHelper.generateSelfLink((Query)query, (ResourcePath)path, (Entity)this.datastream));
        } else {
            if (npMultiDatastream == null) {
                throw new IllegalArgumentException("No Datastream found and MultiDatastream plugin not enabled.");
            }
            this.multiDatastream = (Entity)observation.getProperty(npMultiDatastream);
            this.multiDatastream.setSelfLink(UrlHelper.generateSelfLink((Query)query, (ResourcePath)path, (Entity)this.multiDatastream));
        }
    }

    public Entity getDatastream() {
        return this.datastream;
    }

    public void setDatastream(Entity datastream) {
        if (this.multiDatastream != null) {
            throw new IllegalArgumentException("Can not have both a Datastream and a MultiDatastream.");
        }
        this.datastream = datastream;
    }

    public Entity getMultiDatastream() {
        return this.multiDatastream;
    }

    public void setMultiDatastream(Entity multiDatastream) {
        if (this.datastream != null) {
            throw new IllegalArgumentException("Can not have both a Datastream and a MultiDatastream.");
        }
        this.multiDatastream = multiDatastream;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(List<String> components) {
        this.components = components;
    }

    public List<List<Object>> getDataArray() {
        return this.dataArray;
    }

    public void setDataArray(List<List<Object>> dataArray) {
        this.dataArray = dataArray;
    }

    public DataArrayValue newItemList() {
        this.dataArray.add(new ArrayList());
        return this;
    }

    public DataArrayValue addItemToTail(Object item) {
        this.dataArray.get(this.dataArray.size() - 1).add(item);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.datastream, this.multiDatastream, this.components, this.dataArray);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataArrayValue other = (DataArrayValue)obj;
        if (!Objects.equals(this.datastream, other.datastream)) {
            return false;
        }
        if (!Objects.equals(this.multiDatastream, other.multiDatastream)) {
            return false;
        }
        if (!Objects.equals(this.components, other.components)) {
            return false;
        }
        return Objects.equals(this.dataArray, other.dataArray);
    }

    public static String dataArrayIdFor(Entity observation, NavigationPropertyMain.NavigationPropertyEntity npDatastream, NavigationPropertyMain.NavigationPropertyEntity npMultiDatastream) {
        Entity ds = (Entity)observation.getProperty((Property)npDatastream);
        if (ds == null) {
            if (npMultiDatastream == null) {
                throw new IllegalArgumentException("No Datastream found and MultiDatastream plugin not enabled.");
            }
            Entity mds = (Entity)observation.getProperty((Property)npMultiDatastream);
            return "mds-" + mds.getId().getValue().toString();
        }
        return "ds-" + ds.getId().getValue().toString();
    }
}

