/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import de.fraunhofer.iosb.ilt.frostserver.model.DefaultEntity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInstant;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeInterval;
import de.fraunhofer.iosb.ilt.frostserver.model.ext.TimeValue;
import de.fraunhofer.iosb.ilt.frostserver.plugin.coremodel.PluginCoreModel;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginManager;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.ParserUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayValueHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayValueHandlers.class);
    private final Map<String, ArrayValueHandler> handlers = new HashMap<String, ArrayValueHandler>();

    public ArrayValueHandler getHandler(CoreSettings settings, String component) {
        if (this.handlers.isEmpty()) {
            this.createDefaults(settings);
        }
        return this.handlers.get(component);
    }

    private synchronized void createDefaults(CoreSettings settings) {
        PluginManager pluginManager = settings.getPluginManager();
        PluginCoreModel pluginCoreModel = (PluginCoreModel)pluginManager.getPlugin(PluginCoreModel.class);
        if (!this.handlers.isEmpty()) {
            return;
        }
        ArrayValueHandler idHandler = (value, target) -> target.setId(ParserUtils.idFromObject((Object)value));
        this.handlers.put("id", idHandler);
        this.handlers.put("@iot.id", idHandler);
        this.handlers.put("result", (value, target) -> target.setProperty((Property)pluginCoreModel.epResult, value));
        this.handlers.put("resultQuality", (value, target) -> target.setProperty((Property)pluginCoreModel.epResultQuality, value));
        this.handlers.put("parameters", (value, target) -> {
            if (value instanceof Map) {
                target.setProperty((Property)pluginCoreModel.epParameters, (Object)((Map)value));
                return;
            }
            throw new IllegalArgumentException("parameters has to be a map.");
        });
        this.handlers.put("phenomenonTime", (value, target) -> {
            try {
                TimeInstant time = TimeInstant.parse((String)value.toString());
                target.setProperty((Property)pluginCoreModel.epPhenomenonTime, (Object)new TimeValue(time));
                return;
            }
            catch (Exception e) {
                LOGGER.trace("Not a time instant: {}.", value);
                try {
                    TimeInterval time = TimeInterval.parse((String)value.toString());
                    target.setProperty((Property)pluginCoreModel.epPhenomenonTime, (Object)new TimeValue(time));
                    return;
                }
                catch (Exception e2) {
                    LOGGER.trace("Not a time interval: {}.", value);
                    throw new IllegalArgumentException("phenomenonTime could not be parsed as time instant or time interval.");
                }
            }
        });
        this.handlers.put("resultTime", (value, target) -> {
            try {
                TimeInstant time = TimeInstant.parse((String)value.toString());
                target.setProperty((Property)pluginCoreModel.epResultTime, (Object)time);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("resultTime could not be parsed as time instant or time interval.", e);
            }
        });
        this.handlers.put("validTime", (value, target) -> {
            try {
                TimeInterval time = TimeInterval.parse((String)value.toString());
                target.setProperty((Property)pluginCoreModel.epValidTime, (Object)time);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("resultTime could not be parsed as time instant or time interval.", e);
            }
        });
        this.handlers.put("FeatureOfInterest/id", (value, target) -> {
            Id foiId = ParserUtils.idFromObject((Object)value);
            target.setProperty((Property)pluginCoreModel.npFeatureOfInterestObservation, (Object)new DefaultEntity(pluginCoreModel.etFeatureOfInterest, foiId));
        });
    }

    public static interface ArrayValueHandler {
        public void handle(Object var1, Entity var2);
    }
}

