/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayValue;
import java.io.IOException;

public class DataArrayValueSerializer
extends JsonSerializer<DataArrayValue> {
    private static final String DATAARRAY_IOT_COUNT = "dataArray@iot.count";
    private static final String MULTI_DATASTREAM_IOT_NAVIGATION_LINK = "MultiDatastream@iot.navigationLink";
    private static final String DATASTREAM_IOT_NAVIGATION_LINK = "Datastream@iot.navigationLink";

    public void serialize(DataArrayValue value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        Entity multiDatastream;
        gen.writeStartObject();
        Entity datastream = value.getDatastream();
        if (datastream != null && datastream.getSelfLink() != null) {
            gen.writeStringField(DATASTREAM_IOT_NAVIGATION_LINK, datastream.getSelfLink());
        }
        if ((multiDatastream = value.getMultiDatastream()) != null && multiDatastream.getSelfLink() != null) {
            gen.writeStringField(MULTI_DATASTREAM_IOT_NAVIGATION_LINK, multiDatastream.getSelfLink());
        }
        gen.writeObjectField("components", value.getComponents());
        int count = value.getDataArray().size();
        if (count >= 0) {
            gen.writeNumberField(DATAARRAY_IOT_COUNT, count);
        }
        gen.writeFieldName("dataArray");
        gen.writeObject(value.getDataArray());
        gen.writeEndObject();
    }

    public boolean isEmpty(SerializerProvider provider, DataArrayValue value) {
        return value == null || value.getDataArray().isEmpty();
    }
}

