/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.Observation;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElement;
import de.fraunhofer.iosb.ilt.frostserver.path.PathElementEntitySet;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayResult;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayValue;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFormatterDataArray
implements ResultFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultFormatterDataArray.class);
    private static final String OBSERVATIONS_ONLY = "ResultFormat=dataArray is only valid for /Observations";

    public ResultFormatterDataArray() {
        LOGGER.debug("Creating a new ResultFormaterDataArray.");
    }

    public void preProcessRequest(ResourcePath path, Query query) throws IncorrectRequestException {
        PathElement lastElement;
        if (!(path.getLastElement() instanceof PathElementEntitySet) || path.isRef()) {
            throw new IncorrectRequestException(OBSERVATIONS_ONLY);
        }
        if (!query.getSelect().isEmpty() && (lastElement = path.getLastElement()) instanceof PathElementEntitySet && ((PathElementEntitySet)lastElement).getEntityType() == EntityType.OBSERVATION) {
            query.getSelect().add(NavigationPropertyMain.DATASTREAM);
            query.getSelect().add(NavigationPropertyMain.MULTIDATASTREAM);
        }
    }

    public String format(ResourcePath path, Query query, Object result, boolean useAbsoluteNavigationLinks) {
        String entityJsonString = "";
        try {
            EntitySet entitySet;
            if (EntitySet.class.isAssignableFrom(result.getClass()) && (entitySet = (EntitySet)result).getEntityType() == EntityType.OBSERVATION) {
                return this.formatDataArray(path, query, (EntitySet<Observation>)entitySet);
            }
            throw new IllegalArgumentException(OBSERVATIONS_ONLY);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to format response.", (Throwable)ex);
            return entityJsonString;
        }
    }

    public String getContentType() {
        return "application/json";
    }

    public String formatDataArray(ResourcePath path, Query query, EntitySet<Observation> entitySet) throws IOException {
        VisibleComponents visComps = query == null || query.getSelect().isEmpty() ? new VisibleComponents(true) : new VisibleComponents(query.getSelect());
        List<String> components = visComps.getComponents();
        LinkedHashMap<String, DataArrayValue> dataArraySet = new LinkedHashMap<String, DataArrayValue>();
        for (Observation obs : entitySet) {
            String dataArrayId = DataArrayValue.dataArrayIdFor(obs);
            DataArrayValue dataArray = dataArraySet.computeIfAbsent(dataArrayId, k -> new DataArrayValue(path, obs, components));
            dataArray.getDataArray().add(visComps.fromObservation(obs));
        }
        DataArrayResult result = new DataArrayResult();
        List<DataArrayValue> values = result.getValue();
        for (DataArrayValue daValue : dataArraySet.values()) {
            values.add(daValue);
        }
        result.setCount(entitySet.getCount());
        result.setNextLink(entitySet.getNextLink());
        return JsonWriter.writeObject((Object)result);
    }

    public static class VisibleComponents {
        public final boolean id;
        public final boolean phenomenonTime;
        public final boolean result;
        public final boolean resultTime;
        public final boolean resultQuality;
        public final boolean validTime;
        public final boolean parameters;

        public VisibleComponents() {
            this(false);
        }

        public VisibleComponents(boolean allValue) {
            this.id = allValue;
            this.phenomenonTime = allValue;
            this.result = allValue;
            this.resultTime = allValue;
            this.resultQuality = allValue;
            this.validTime = allValue;
            this.parameters = allValue;
        }

        public VisibleComponents(Set<Property> select) {
            this.id = select.contains(EntityPropertyMain.ID);
            this.phenomenonTime = select.contains(EntityPropertyMain.PHENOMENONTIME);
            this.result = select.contains(EntityPropertyMain.RESULT);
            this.resultTime = select.contains(EntityPropertyMain.RESULTTIME);
            this.resultQuality = select.contains(EntityPropertyMain.RESULTQUALITY);
            this.validTime = select.contains(EntityPropertyMain.VALIDTIME);
            this.parameters = select.contains(EntityPropertyMain.PARAMETERS);
        }

        public List<String> getComponents() {
            ArrayList<String> components = new ArrayList<String>();
            if (this.id) {
                components.add(EntityPropertyMain.ID.entitiyName);
            }
            if (this.phenomenonTime) {
                components.add(EntityPropertyMain.PHENOMENONTIME.entitiyName);
            }
            if (this.result) {
                components.add(EntityPropertyMain.RESULT.entitiyName);
            }
            if (this.resultTime) {
                components.add(EntityPropertyMain.RESULTTIME.entitiyName);
            }
            if (this.resultQuality) {
                components.add(EntityPropertyMain.RESULTQUALITY.entitiyName);
            }
            if (this.validTime) {
                components.add(EntityPropertyMain.VALIDTIME.entitiyName);
            }
            if (this.parameters) {
                components.add(EntityPropertyMain.PARAMETERS.entitiyName);
            }
            return components;
        }

        public List<Object> fromObservation(Observation o) {
            ArrayList<Object> value = new ArrayList<Object>();
            if (this.id) {
                value.add(o.getId().getValue());
            }
            if (this.phenomenonTime) {
                value.add(o.getPhenomenonTime());
            }
            if (this.result) {
                value.add(o.getResult());
            }
            if (this.resultTime) {
                value.add(o.getResultTime());
            }
            if (this.resultQuality) {
                value.add(o.getResultQuality());
            }
            if (this.validTime) {
                value.add(o.getValidTime());
            }
            if (this.parameters) {
                value.add(o.getParameters());
            }
            return value;
        }
    }
}

