/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import de.fraunhofer.iosb.ilt.frostserver.model.Datastream;
import de.fraunhofer.iosb.ilt.frostserver.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.frostserver.model.Observation;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(value={"dataArray@iot.count"})
public class DataArrayValue {
    public static final TypeReference<List<DataArrayValue>> LIST_OF_DATAARRAYVALUE = new TypeReference<List<DataArrayValue>>(){};
    @JsonProperty(value="Datastream")
    private Datastream datastream;
    @JsonProperty(value="MultiDatastream")
    private MultiDatastream multiDatastream;
    private List<String> components;
    private List<List<Object>> dataArray = new ArrayList<List<Object>>();

    public DataArrayValue() {
    }

    public DataArrayValue(Datastream datastream, List<String> components) {
        this.datastream = datastream;
        this.components = components;
    }

    public DataArrayValue(MultiDatastream multiDatastream, List<String> components) {
        this.multiDatastream = multiDatastream;
        this.components = components;
    }

    public DataArrayValue(ResourcePath path, Observation observation, List<String> components) {
        this.datastream = observation.getDatastream();
        this.multiDatastream = observation.getMultiDatastream();
        this.components = components;
        if (this.datastream != null) {
            this.datastream.setSelfLink(UrlHelper.generateSelfLink((ResourcePath)path, (Entity)this.datastream));
        }
        if (this.multiDatastream != null) {
            this.multiDatastream.setSelfLink(UrlHelper.generateSelfLink((ResourcePath)path, (Entity)this.multiDatastream));
        }
    }

    public Datastream getDatastream() {
        return this.datastream;
    }

    public void setDatastream(Datastream datastream) {
        if (this.multiDatastream != null) {
            throw new IllegalArgumentException("Can not have both a Datastream and a MultiDatastream.");
        }
        this.datastream = datastream;
    }

    public MultiDatastream getMultiDatastream() {
        return this.multiDatastream;
    }

    public void setMultiDatastream(MultiDatastream multiDatastream) {
        if (this.datastream != null) {
            throw new IllegalArgumentException("Can not have both a Datastream and a MultiDatastream.");
        }
        this.multiDatastream = multiDatastream;
    }

    public List<String> getComponents() {
        return this.components;
    }

    public void setComponents(List<String> components) {
        this.components = components;
    }

    public List<List<Object>> getDataArray() {
        return this.dataArray;
    }

    public void setDataArray(List<List<Object>> dataArray) {
        this.dataArray = dataArray;
    }

    public DataArrayValue newItemList() {
        this.dataArray.add(new ArrayList());
        return this;
    }

    public DataArrayValue addItemToTail(Object item) {
        this.dataArray.get(this.dataArray.size() - 1).add(item);
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.datastream, this.multiDatastream, this.components, this.dataArray);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataArrayValue other = (DataArrayValue)obj;
        if (!Objects.equals(this.datastream, other.datastream)) {
            return false;
        }
        if (!Objects.equals(this.multiDatastream, other.multiDatastream)) {
            return false;
        }
        if (!Objects.equals(this.components, other.components)) {
            return false;
        }
        return Objects.equals(this.dataArray, other.dataArray);
    }

    public static String dataArrayIdFor(Observation observation) {
        Datastream ds = observation.getDatastream();
        if (ds == null) {
            MultiDatastream mds = observation.getMultiDatastream();
            return "mds-" + mds.getId().getValue().toString();
        }
        return "ds-" + ds.getId().getValue().toString();
    }
}

