/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray;

import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.json.deserialize.JsonReader;
import de.fraunhofer.iosb.ilt.frostserver.model.Datastream;
import de.fraunhofer.iosb.ilt.frostserver.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.frostserver.model.Observation;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.persistence.PersistenceManager;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.dataarray.DataArrayValue;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.ArrayValueHandlers;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncompleteEntityException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.NoSuchEntityException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDataArray {
    public static final String PATH_CREATE_OBSERVATIONS = "/CreateObservations";
    public static final String REQUEST_TYPE_CREATE_OBSERVATIONS = "createObservations";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceDataArray.class);
    private final CoreSettings settings;

    public ServiceDataArray(CoreSettings settings) {
        this.settings = settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ServiceResponse<T> executeCreateObservations(Service service, ServiceRequest request) {
        ServiceResponse response = new ServiceResponse();
        Version version = request.getVersion();
        PersistenceManager pm = service.getPm();
        try {
            JsonReader entityParser = new JsonReader(pm.getIdManager().getIdClass());
            List postData = (List)entityParser.parseObject(DataArrayValue.LIST_OF_DATAARRAYVALUE, request.getContent());
            ArrayList<String> selfLinks = new ArrayList<String>();
            for (DataArrayValue daValue : postData) {
                Datastream datastream = daValue.getDatastream();
                MultiDatastream multiDatastream = daValue.getMultiDatastream();
                ArrayList<ArrayValueHandlers.ArrayValueHandler> handlers = new ArrayList<ArrayValueHandlers.ArrayValueHandler>();
                for (String component : daValue.getComponents()) {
                    handlers.add(ArrayValueHandlers.getHandler((CoreSettings)this.settings, (String)component));
                }
                this.handleDataArrayItems(version, handlers, daValue, datastream, multiDatastream, pm, selfLinks);
            }
            service.maybeCommitAndClose();
            ResultFormatter formatter = this.settings.getFormatter("default");
            response.setResultFormatted(formatter.format(null, null, selfLinks, this.settings.getQueryDefaults().useAbsoluteNavigationLinks()));
            response.setContentType(formatter.getContentType());
            ServiceResponse serviceResponse = Service.successResponse((ServiceResponse)response, (int)201, (String)"Created");
            return serviceResponse;
        }
        catch (IOException | IllegalArgumentException e) {
            pm.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse((ServiceResponse)response, (int)400, (String)e.getMessage());
            return serviceResponse;
        }
        catch (RuntimeException e) {
            pm.rollbackAndClose();
            ServiceResponse serviceResponse = Service.errorResponse((ServiceResponse)response, (int)500, (String)e.getMessage());
            return serviceResponse;
        }
        catch (IncorrectRequestException ex) {
            LOGGER.error("Formatter not available.", (Throwable)ex);
            ServiceResponse serviceResponse = Service.errorResponse((ServiceResponse)response, (int)500, (String)"Failed to instantiate formatter");
            return serviceResponse;
        }
        finally {
            service.maybeRollbackAndClose();
        }
    }

    private void handleDataArrayItems(Version version, List<ArrayValueHandlers.ArrayValueHandler> handlers, DataArrayValue daValue, Datastream datastream, MultiDatastream multiDatastream, PersistenceManager pm, List<String> selfLinks) {
        String serviceRootUrl = this.settings.getQueryDefaults().getServiceRootUrl();
        int compCount = handlers.size();
        for (List<Object> entry : daValue.getDataArray()) {
            try {
                Observation observation = new Observation();
                observation.setDatastream(datastream);
                observation.setMultiDatastream(multiDatastream);
                for (int i = 0; i < compCount; ++i) {
                    handlers.get(i).handle(entry.get(i), observation);
                }
                pm.insert((Entity)observation);
                String selfLink = UrlHelper.generateSelfLink((String)serviceRootUrl, (Version)version, (Entity)observation);
                selfLinks.add(selfLink);
            }
            catch (IncompleteEntityException | NoSuchEntityException | IllegalArgumentException exc) {
                LOGGER.debug("Failed to create entity", exc);
                selfLinks.add("error " + exc.getMessage());
            }
        }
    }
}

