/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools;

import de.fraunhofer.iosb.ilt.frostserver.model.ComplexValue;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvEntityEntry;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvRowCollector;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import java.util.Map;
import java.util.TreeMap;

public class CsvComplexProperty
implements CsvEntityEntry {
    private final String headerPrefix;
    private final EntityProperty property;
    private final Map<Integer, String> subProperties = new TreeMap<Integer, String>();

    public CsvComplexProperty(String headerPrefix, EntityProperty property) {
        this.headerPrefix = headerPrefix;
        this.property = property;
    }

    @Override
    public void writeHeader(CsvRowCollector collector) {
        String baseName = this.property.getJsonName();
        TypeComplex type = (TypeComplex)this.property.getType();
        for (Map.Entry subProperty : type.getPropertiesByName().entrySet()) {
            String subName = (String)subProperty.getKey();
            int idx = collector.registerHeader(this.headerPrefix + baseName + "/" + subName);
            this.subProperties.put(idx, subName);
        }
    }

    @Override
    public void writeData(CsvRowCollector collector, Entity source) {
        block3: {
            Object value;
            block2: {
                value = source.getProperty((Property)this.property);
                if (!(value instanceof ComplexValue)) break block2;
                ComplexValue complexValue = (ComplexValue)value;
                for (Map.Entry<Integer, String> entry : this.subProperties.entrySet()) {
                    collector.collectEntry(entry.getKey(), complexValue.getProperty(entry.getValue()));
                }
                break block3;
            }
            if (!(value instanceof Map)) break block3;
            Map mapValue = (Map)value;
            for (Map.Entry<Integer, String> entry : this.subProperties.entrySet()) {
                collector.collectEntry(entry.getKey(), mapValue.get(entry.getValue()));
            }
        }
    }
}

