/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools;

import de.fraunhofer.iosb.ilt.frostserver.util.SimpleJsonMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVPrinter;
import org.geojson.GeoJsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvRowCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvRowCollector.class);
    private final CSVPrinter printer;
    private final List<Object> elements = new ArrayList<Object>();
    private int countTotal = 0;
    private int pointer = 0;

    public CsvRowCollector(CSVPrinter printer) {
        this.printer = printer;
    }

    public int registerHeader(String headerName) {
        this.elements.add(headerName);
        this.countTotal = this.elements.size();
        ++this.pointer;
        return this.countTotal - 1;
    }

    public void collectEntry(int idx, Object value) {
        if (idx < this.pointer) {
            throw new IllegalArgumentException("Elements must be collected in order.");
        }
        while (this.pointer < idx) {
            this.elements.set(this.pointer, null);
            ++this.pointer;
        }
        if (value == null) {
            this.elements.set(idx, value);
        } else if (value instanceof Collection || value instanceof Map || value instanceof GeoJsonObject || value.getClass().isArray()) {
            try {
                String json = SimpleJsonMapper.getSimpleObjectMapper().writeValueAsString(value);
                this.elements.set(idx, json);
            }
            catch (IOException ex) {
                LOGGER.warn("Could not transform collection to JSON.", (Throwable)ex);
                this.elements.set(idx, value);
            }
        } else {
            this.elements.set(idx, value);
        }
        ++this.pointer;
    }

    public void flush() throws IOException {
        while (this.pointer < this.countTotal) {
            this.elements.set(this.pointer, null);
            ++this.pointer;
        }
        this.printer.printRecord(this.elements);
        this.pointer = 0;
    }
}

