/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.ModelRegistry;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvComplexProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvEntityEntry;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvEntityExpand;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvEntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvRowCollector;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.NavigationPropertyFollower;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyCustomSelect;
import de.fraunhofer.iosb.ilt.frostserver.property.EntityPropertyMain;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.property.Property;
import de.fraunhofer.iosb.ilt.frostserver.property.type.PropertyType;
import de.fraunhofer.iosb.ilt.frostserver.property.type.TypeComplex;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvElementSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(CsvElementSet.class);
    private final String namePrefix;
    private final List<CsvEntityEntry> elements = new ArrayList<CsvEntityEntry>();

    public CsvElementSet(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void initFrom(EntityType type, Query query) {
        if (query == null || query.getSelect().isEmpty()) {
            this.initFrom(type.getPropertySet(), query);
        } else {
            this.initFrom(query.getSelect(), query);
        }
    }

    public void initFrom(Set<Property> properties, Query query) {
        this.initProperties(properties);
        if (query == null) {
            return;
        }
        for (Expand expand : query.getExpand()) {
            NavigationProperty path = expand.getPath();
            this.initFrom(path, expand.getSubQuery());
        }
    }

    private void initProperties(Set<Property> properties) {
        for (Property property : properties) {
            if (property == ModelRegistry.EP_SELFLINK) continue;
            if (property instanceof EntityPropertyMain) {
                this.initFrom((EntityPropertyMain)property);
                continue;
            }
            if (!(property instanceof EntityPropertyCustomSelect)) continue;
            this.initFrom((EntityPropertyCustomSelect)property);
        }
    }

    public void initFrom(EntityPropertyMain property) {
        PropertyType type = property.getType();
        CsvEntityEntry element = type instanceof TypeComplex && !((TypeComplex)type).isOpenType() ? new CsvComplexProperty(this.namePrefix, (EntityProperty)property) : new CsvEntityProperty(this.namePrefix + property.name, (EntityProperty)property);
        this.elements.add(element);
    }

    public void initFrom(EntityPropertyCustomSelect property) {
        CsvEntityProperty element = new CsvEntityProperty(this.namePrefix + property.getName(), (EntityProperty)property);
        this.elements.add(element);
    }

    public void initFrom(NavigationProperty property, Query query) {
        CsvEntityExpand element = new CsvEntityExpand(this.namePrefix + property.getName() + "/", property, query, new NavigationPropertyFollowerDefault(property));
        this.elements.add(element);
    }

    public void writeHeader(CsvRowCollector collector) {
        for (CsvEntityEntry element : this.elements) {
            element.writeHeader(collector);
        }
    }

    public void writeData(CsvRowCollector collector, Object obj) throws IOException {
        if (obj instanceof Entity) {
            this.writeData(collector, (Entity)obj);
        } else if (obj instanceof EntitySet) {
            this.writeData(collector, (EntitySet)obj);
        }
    }

    public void writeData(CsvRowCollector collector, Entity entity) {
        if (entity == null) {
            return;
        }
        for (CsvEntityEntry element : this.elements) {
            element.writeData(collector, entity);
        }
    }

    public void writeData(CsvRowCollector collector, EntitySet entitySet) throws IOException {
        if (entitySet == null) {
            return;
        }
        for (Entity e : entitySet) {
            for (CsvEntityEntry element : this.elements) {
                element.writeData(collector, e);
            }
            collector.flush();
        }
    }

    private static class NavigationPropertyFollowerDefault
    implements NavigationPropertyFollower {
        private final NavigationProperty property;

        public NavigationPropertyFollowerDefault(NavigationProperty getter) {
            this.property = getter;
        }

        @Override
        public Entity fetch(Entity source) {
            try {
                Object result = this.property.getFrom(source);
                if (result instanceof Entity) {
                    return (Entity)result;
                }
                if (result instanceof EntitySet) {
                    EntitySet entitySet = (EntitySet)result;
                    return entitySet.isEmpty() ? null : (Entity)entitySet.iterator().next();
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Failed to read element", (Throwable)ex);
            }
            return null;
        }
    }
}

