/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv;

import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.path.ResourcePath;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvElementSet;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.tools.CsvRowCollector;
import de.fraunhofer.iosb.ilt.frostserver.property.NavigationProperty;
import de.fraunhofer.iosb.ilt.frostserver.query.Expand;
import de.fraunhofer.iosb.ilt.frostserver.query.Query;
import de.fraunhofer.iosb.ilt.frostserver.util.exception.IncorrectRequestException;
import java.io.IOException;
import java.io.StringWriter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFormatterCsv
implements ResultFormatter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultFormatterCsv.class);

    public void preProcessRequest(ResourcePath path, Query query) throws IncorrectRequestException {
        this.validateQuery(query);
    }

    private void validateQuery(Query query) throws IncorrectRequestException {
        if (query == null) {
            return;
        }
        for (Expand expand : query.getExpand()) {
            this.validateExpand(expand);
        }
    }

    private void validateExpand(Expand expand) throws IncorrectRequestException {
        Query subQuery;
        NavigationProperty pathItem = expand.getPath();
        if (pathItem.isEntitySet() && ((subQuery = expand.getSubQuery()) == null || subQuery.getTopOrDefault() != 1)) {
            throw new IncorrectRequestException("The CSV ResultFormat only allows expand on sets with $top=1.");
        }
        this.validateQuery(expand.getSubQuery());
    }

    public String format(ResourcePath path, Query query, Object result, boolean useAbsoluteNavigationLinks) {
        EntityType type = path.getMainElementType();
        CsvElementSet elementSet = new CsvElementSet("");
        elementSet.initFrom(type, query);
        StringWriter writer = new StringWriter();
        try (CSVPrinter printer = new CSVPrinter((Appendable)writer, CSVFormat.RFC4180);){
            CsvRowCollector rowCollector = new CsvRowCollector(printer);
            elementSet.writeHeader(rowCollector);
            rowCollector.flush();
            elementSet.writeData(rowCollector, result);
        }
        catch (IOException ex) {
            LOGGER.error("Failed to generate CSV String.", (Throwable)ex);
        }
        return writer.toString();
    }

    public String getContentType() {
        return "text/csv";
    }
}

