/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv;

import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatter;
import de.fraunhofer.iosb.ilt.frostserver.plugin.format.csv.ResultFormatterCsv;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginResultFormat;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PluginResultFormatCsv
implements PluginResultFormat,
PluginRootDocument,
ConfigDefaults {
    @DefaultValueBoolean(value=true)
    public static final String TAG_ENABLE_CSV = "csv.enable";
    private static final String REQUIREMENT_CSV = "https://github.com/INSIDE-information-systems/SensorThingsAPI/blob/master/CSV-ResultFormat/CSV-ResultFormat.md";
    public static final String CSV_FORMAT_NAME = "CSV";

    public void init(CoreSettings settings) {
        Settings pluginSettings = settings.getPluginSettings();
        boolean enabled = pluginSettings.getBoolean(TAG_ENABLE_CSV, this.getClass());
        if (enabled) {
            settings.getPluginManager().registerPlugin((Plugin)this);
        }
    }

    public Collection<String> getFormatNames() {
        return Arrays.asList(CSV_FORMAT_NAME);
    }

    public ResultFormatter getResultFormatter() {
        return new ResultFormatterCsv();
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        Map serverSettings = (Map)result.get("serverSettings");
        if (serverSettings == null) {
            return;
        }
        Set extensionList = (Set)serverSettings.get("conformance");
        extensionList.add(REQUIREMENT_CSV);
    }
}

