/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Part;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.HttpContent;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MixedContent;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MultipartContent;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.StringContent;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedPart
extends Part<MultipartContent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MixedPart.class);
    private State parseState = State.INITIAL;

    public MixedPart(Version batchVersion, CoreSettings settings, boolean inChangeSet, String logIndent) {
        super(batchVersion, settings, inChangeSet, logIndent);
    }

    public MultipartContent.IsFinished isFinished() {
        if (this.content == null) {
            return MultipartContent.IsFinished.UNKNOWN;
        }
        return ((MultipartContent)this.content).isFinished();
    }

    private void addHeader(String line) {
        Matcher matcher = MixedContent.HEADER_PATTERN.matcher(line);
        if (!matcher.find()) {
            LOGGER.debug("{}Found non-header line, assuming content: '{}'", (Object)this.logIndent, (Object)line);
            this.content = new StringContent();
            ((MultipartContent)this.content).parseLine(line);
            return;
        }
        String name = matcher.group(1).trim().toLowerCase();
        String value = matcher.group(2).trim();
        this.headers.put(name, value);
        LOGGER.debug("{}Found header '{}' : '{}'", new Object[]{this.logIndent, name, value});
        String rest = line.substring(matcher.end());
        if (StringHelper.isNullOrEmpty((String)rest)) {
            return;
        }
        Matcher subHeaderMatcher = MixedContent.SUB_HEADER_PATTERN.matcher(rest);
        while (subHeaderMatcher.find()) {
            String subName = subHeaderMatcher.group(1).trim().toLowerCase();
            String subValue = subHeaderMatcher.group(2).trim();
            this.headers.put(subName, subValue);
            LOGGER.debug("{}  Found subheader '{}' : '{}'", new Object[]{this.logIndent, subName, subValue});
        }
    }

    public void appendLine(String line) {
        switch (this.parseState.ordinal()) {
            case 0: {
                this.addHeader(line);
                this.determineType();
                break;
            }
            case 1: {
                ((MultipartContent)this.content).parseLine(line);
                if (((MultipartContent)this.content).isFinished() != MultipartContent.IsFinished.FINISHED) break;
                this.setParseState(State.DONE);
                break;
            }
            case 2: {
                LOGGER.debug("{}Epilogue line: {}", (Object)this.logIndent, (Object)line);
                break;
            }
            default: {
                LOGGER.warn("{}Uhandled state: {}.", (Object)this.logIndent, (Object)this.parseState);
            }
        }
    }

    private void determineType() {
        String contentType = this.getHeader("content-type");
        if ("multipart/mixed".equalsIgnoreCase(contentType)) {
            if (this.inChangeSet) {
                throw new IllegalArgumentException("ChangeSets not allowed in ChangeSets.");
            }
            LOGGER.debug("{}Found multipart content", (Object)this.logIndent);
            this.content = new MixedContent(this.batchVersion, this.settings, true).setBoundaryHeader(this.getHeader("boundary"));
        } else if ("application/http".equalsIgnoreCase(contentType)) {
            LOGGER.debug("{}Found Http content", (Object)this.logIndent);
            this.content = new HttpContent(this.batchVersion, this.inChangeSet);
        } else {
            LOGGER.error("{}No or unknown content-type: {}", (Object)this.logIndent, (Object)contentType);
            if (this.inChangeSet) {
                throw new IllegalArgumentException("Only application/http content allowed in ChangeSets.");
            }
            if (this.content == null) {
                this.content = new StringContent();
            }
        }
        ((MultipartContent)this.content).setLogIndent(this.logIndent + "  ");
        this.setParseState(State.DATA);
    }

    private void setParseState(State parseState) {
        this.parseState = parseState;
        LOGGER.debug("{}Now in state: {}", (Object)this.logIndent, (Object)parseState);
    }

    public void stripLastNewline() {
        if (this.content == null) {
            return;
        }
        ((MultipartContent)this.content).stripLastNewline();
    }

    private static enum State {
        INITIAL,
        DATA,
        DONE;

    }
}

