/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRawValue;
import com.fasterxml.jackson.core.JsonProcessingException;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBatchResultItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonBatchResultItem.class);
    public EntityType entityType;
    public String id;
    public PkValue idValue;
    public int status;
    public Map<String, Object> headers = new HashMap<String, Object>();
    public String body = null;
    public String location;

    @JsonRawValue
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getBody() {
        return this.body;
    }

    public JsonBatchResultItem setBodyNotFormatted(Object body) {
        try {
            this.body = JsonWriter.getObjectMapper().writeValueAsString(body);
        }
        catch (JsonProcessingException ex) {
            LOGGER.error("Failed to convert String into JSON. This should never happen.");
        }
        return this;
    }

    public JsonBatchResultItem setBodyJsonFormatted(String body) {
        if (!StringHelper.isNullOrEmpty((String)body)) {
            this.body = body;
        }
        return this;
    }

    @JsonIgnore
    public EntityType getEntityType() {
        return this.entityType;
    }

    public JsonBatchResultItem setEntityType(EntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public JsonBatchResultItem addHeaders(Map<String, List<String>> values) {
        values.entrySet().forEach(x -> this.addHeaders((String)x.getKey(), (List)x.getValue()));
        return this;
    }

    public JsonBatchResultItem addHeaders(String name, List<String> values) {
        for (String value : values) {
            this.addHeader(name, value);
        }
        return this;
    }

    public JsonBatchResultItem addHeader(String name, String value) {
        Object oldVal = this.headers.get(name);
        if (oldVal instanceof String) {
            String s = (String)oldVal;
            ArrayList<String> list = new ArrayList<String>();
            list.add(s);
            list.add(value);
            this.headers.put(name, list);
        } else if (oldVal instanceof List) {
            List list = (List)oldVal;
            list.add(value);
        } else {
            this.headers.put(name, value);
        }
        if ("location".equalsIgnoreCase(name)) {
            this.location = value;
        }
        return this;
    }

    public JsonBatchResultItem setHeader(String name, String value) {
        this.headers.put(name, Arrays.asList(value));
        return this;
    }

    public String getId() {
        return this.id;
    }

    public JsonBatchResultItem setId(String id) {
        this.id = id;
        return this;
    }

    @JsonIgnore
    public PkValue getIdValue() {
        return this.idValue;
    }

    public JsonBatchResultItem setIdValue(PkValue idValue) {
        this.idValue = idValue;
        return this;
    }

    public String getLocation() {
        return this.location;
    }

    public JsonBatchResultItem setLocation(String location) {
        this.location = location;
        return this;
    }

    public int getStatus() {
        return this.status;
    }

    @JsonIgnore
    public boolean isFailed() {
        return this.status < 200 || this.status >= 300;
    }

    public JsonBatchResultItem setStatus(int code) {
        this.status = code;
        return this;
    }
}

