/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.ContentIdPair;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class JsonBatchRequestItem {
    private String atomicityGroup;
    private String body;
    private Map<String, List<String>> headers;
    private String id;
    private String method;
    private String url;
    private String ifCondition;

    public String getAtomicityGroup() {
        return this.atomicityGroup;
    }

    public JsonBatchRequestItem setAtomicityGroup(String atomicityGroup) {
        this.atomicityGroup = atomicityGroup;
        return this;
    }

    public String getBody() {
        return this.body;
    }

    @JsonDeserialize(using=BodyDeserializer.class)
    public JsonBatchRequestItem setBody(String body) {
        this.body = body;
        return this;
    }

    public String getContentType() {
        List<String> contentType = this.getHeaders().get("content-type");
        if (StringHelper.isNullOrEmpty(contentType)) {
            return "application/json";
        }
        return contentType.get(0);
    }

    public Map<String, List<String>> getHeaders() {
        if (this.headers == null) {
            this.headers = new HashMap<String, List<String>>();
        }
        return this.headers;
    }

    @JsonDeserialize(using=HeadersDeserializer.class)
    public JsonBatchRequestItem setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public JsonBatchRequestItem setId(String id) {
        this.id = id;
        return this;
    }

    public String getIfCondition() {
        return this.ifCondition;
    }

    @JsonProperty(value="if")
    public void setIfCondition(String ifCondition) {
        this.ifCondition = ifCondition;
    }

    public boolean matchesIfCondition(Map<String, ContentIdPair> ids) {
        if (StringHelper.isNullOrEmpty((String)this.ifCondition)) {
            return true;
        }
        String myIfCondition = this.ifCondition.trim();
        boolean not = myIfCondition.startsWith("not ");
        myIfCondition = StringUtils.removeStart((String)myIfCondition, (String)"not ").trim();
        boolean found = ids.containsKey(StringUtils.removeStart((String)myIfCondition, (String)"$"));
        if (not) {
            return !found;
        }
        return found;
    }

    public String getMethod() {
        return this.method;
    }

    public JsonBatchRequestItem setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public JsonBatchRequestItem setUrl(String url) {
        this.url = url;
        return this;
    }

    public static class HeadersDeserializer
    extends JsonDeserializer<Map<String, List<String>>> {
        public Map<String, List<String>> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            JsonNode tree = (JsonNode)mapper.readTree(jp);
            HashMap<String, List<String>> result = new HashMap<String, List<String>>();
            Iterator fields = tree.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                String name = ((String)entry.getKey()).toLowerCase();
                JsonNode value = (JsonNode)entry.getValue();
                if (value.isValueNode()) {
                    result.put(name, Arrays.asList(value.asText()));
                    continue;
                }
                ArrayList<String> list = new ArrayList<String>();
                for (JsonNode v : value) {
                    list.add(v.asText());
                }
                result.put(name, list);
            }
            return result;
        }
    }

    public static class BodyDeserializer
    extends JsonDeserializer<String> {
        public String deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectMapper mapper = (ObjectMapper)jp.getCodec();
            TreeNode tree = mapper.readTree(jp);
            return mapper.writeValueAsString((Object)tree);
        }
    }
}

