/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.EntitySet;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.ContentIdPair;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json.JsonBatchRequestItem;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json.JsonBatchResponse;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json.JsonBatchResultItem;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginManager;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponseDefault;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBatchProcessor
implements Iterator<JsonBatchResultItem> {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JsonBatchProcessor.class.getName());
    private static final String REFERENCE_URL_REGEX = "^" + Pattern.quote("$") + "([a-zA-Z0-9_.:,;-]+)";
    private static final Pattern REFERENCE_URL_PATTERN = Pattern.compile(REFERENCE_URL_REGEX);
    private static final String REFERENCE_JSON_REGEX = Pattern.quote("\"$") + "([a-zA-Z0-9_.:,;-]+)" + Pattern.quote("\"");
    private static final Pattern REFERENCE_JSON_PATTERN = Pattern.compile(REFERENCE_JSON_REGEX);
    private final Service service;
    private final ServiceRequest request;
    private final ServiceResponse response;
    private Path tempFile;
    private JsonParser parser;
    private JsonBatchResultItem next;
    private String currentGroup = "";
    private boolean groupFailed = false;
    private final Map<String, ContentIdPair> ids = new HashMap<String, ContentIdPair>();

    public JsonBatchProcessor(Service service, ServiceRequest request, ServiceResponse response) {
        this.service = service;
        this.request = request;
        this.response = response;
    }

    public JsonBatchResponse processRequest(boolean stream) {
        try {
            ObjectMapper mapper = this.request.getJsonReader().getMapper();
            if (stream) {
                this.parser = mapper.createParser(this.request.getContentReader());
            } else {
                this.tempFile = Files.createTempFile(null, null, new FileAttribute[0]);
                try (BufferedWriter tempWriter = Files.newBufferedWriter(this.tempFile, new OpenOption[0]);){
                    IOUtils.copy((Reader)this.request.getContentReader(), (Writer)tempWriter);
                    tempWriter.flush();
                }
                this.parser = mapper.createParser(this.tempFile.toFile());
            }
            JsonToken currentToken = this.parser.nextToken();
            while (currentToken != null) {
                String fieldName;
                if (currentToken == JsonToken.FIELD_NAME && "requests".equalsIgnoreCase(fieldName = this.parser.currentName())) {
                    currentToken = this.parser.nextToken();
                    if (currentToken != JsonToken.START_ARRAY) {
                        throw new IllegalArgumentException("requests must be an array, found " + String.valueOf(currentToken));
                    }
                    JsonBatchResponse result = new JsonBatchResponse().setResponses(this);
                    this.response.setResult((Object)result);
                    return result;
                }
                currentToken = this.parser.nextToken();
            }
        }
        catch (IOException | RuntimeException ex) {
            this.close();
            throw new IllegalArgumentException("Failed to read input");
        }
        throw new IllegalArgumentException("No requests found in input");
    }

    public void close() {
        if (this.parser != null) {
            try {
                this.parser.close();
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to close parser: {}", (Object)ex.getMessage());
                LOGGER.debug("Failed to close parser.", (Throwable)ex);
            }
        }
        if (this.tempFile != null) {
            try {
                Files.deleteIfExists(this.tempFile);
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to delete temp file: {}", (Object)ex.getMessage());
                LOGGER.debug("Failed to delete temp file.", (Throwable)ex);
            }
        }
    }

    public void processNextRequest() {
        if (this.parser == null) {
            return;
        }
        try {
            if (this.parser.nextToken() == JsonToken.START_OBJECT) {
                JsonBatchRequestItem item = (JsonBatchRequestItem)this.parser.readValueAs(JsonBatchRequestItem.class);
                String itemGroup = item.getAtomicityGroup();
                if (itemGroup == null || !StringUtils.equals((CharSequence)this.currentGroup, (CharSequence)itemGroup)) {
                    this.service.commitTransaction();
                    this.service.startTransaction((Principal)this.request.getUserPrincipal());
                    this.currentGroup = itemGroup;
                    this.ids.clear();
                    this.groupFailed = false;
                }
                this.next = this.groupFailed ? new JsonBatchResultItem().setStatus(400).setBodyNotFormatted("Skipped due to previous failure in atomicityGroup.") : this.processRequestItem(this.service, item);
                if (this.next.isFailed()) {
                    this.groupFailed = true;
                    this.service.rollbackTransaction();
                }
            } else if (this.parser.currentToken() == JsonToken.END_ARRAY && !this.groupFailed) {
                this.service.commitTransaction();
            }
        }
        catch (IOException ex) {
            LOGGER.info("Failed to parse json.", (Object)ex.getMessage());
            LOGGER.debug("Failed to parse json.", (Throwable)ex);
            this.service.rollbackTransaction();
            this.parser = null;
            this.next = new JsonBatchResultItem().setStatus(400).setBodyNotFormatted("Failed to parse json: " + ex.getMessage());
        }
    }

    private String replaceIdsUrl(String url) {
        Matcher matcher = REFERENCE_URL_PATTERN.matcher(url);
        if (matcher.find()) {
            String name = matcher.group(1);
            ContentIdPair pair = this.ids.get(name);
            if (pair == null) {
                LOGGER.debug("Not a match: {}", (Object)matcher.group(0));
                return "/" + url;
            }
            String value = pair.selfLink();
            return value + url.substring(matcher.end(0));
        }
        return "/" + url;
    }

    private String replaceIdsJson(String body) {
        if (StringHelper.isNullOrEmpty((String)body)) {
            return body;
        }
        Matcher matcher = REFERENCE_JSON_PATTERN.matcher(body);
        StringBuilder result = new StringBuilder();
        int idx = 0;
        while (matcher.find()) {
            result.append(body.substring(idx, matcher.start(0)));
            String name = matcher.group(1);
            ContentIdPair pair = this.ids.get(name);
            if (pair == null) {
                LOGGER.debug("Not a match: {}", (Object)matcher.group(0));
                result.append(matcher.group(0));
            } else {
                String value = UrlHelper.quoteForJson((Object)pair.value.get(0));
                result.append(value);
            }
            idx = matcher.end(0);
        }
        result.append(body.substring(idx));
        return result.toString();
    }

    public JsonBatchResultItem processRequestItem(Service service, JsonBatchRequestItem requestItem) {
        Object createdObject;
        Entity entity;
        CoreSettings coreSettings = service.getSettings();
        Version version = this.request.getVersion();
        String requestId = requestItem.getId();
        String path = requestItem.getUrl();
        path = this.replaceIdsUrl(path);
        if (!requestItem.matchesIfCondition(this.ids)) {
            return new JsonBatchResultItem().setId(requestId).setStatus(200).setBodyNotFormatted("Skipped due to if.");
        }
        PluginService plugin = coreSettings.getPluginManager().getServiceForPath(version, path);
        if (plugin == null) {
            return new JsonBatchResultItem().setId(requestId).setStatus(400).setBodyNotFormatted("Unknown URL: " + path);
        }
        String method = requestItem.getMethod();
        String requestType = PluginManager.decodeRequestType((PluginService)plugin, (Version)version, (String)path, (String)method, (String)requestItem.getContentType());
        String requestBody = this.replaceIdsJson(requestItem.getBody());
        ServiceRequest serviceRequest = new ServiceRequest().setCoreSettings(coreSettings).setVersion(version).setRequestType(requestType).setUpdateMode("create".equals(requestType) ? UpdateMode.INSERT_STA_11 : UpdateMode.UPDATE_STA_11).setUrl(path).setContent(requestBody).setUserPrincipal(this.request.getUserPrincipal());
        ServiceResponseDefault serviceResponse = new ServiceResponseDefault();
        plugin.execute(service, serviceRequest, (ServiceResponse)serviceResponse);
        int statusCode = serviceResponse.getCode();
        JsonBatchResultItem result = new JsonBatchResultItem().setId(requestId).setStatus(statusCode).addHeaders(serviceResponse.getHeaders());
        String contentType = serviceResponse.getContentType();
        String responseContent = serviceResponse.getWriter().toString();
        if (contentType == null || "application/json".equalsIgnoreCase(contentType.split(";", 2)[0])) {
            result.setBodyJsonFormatted(responseContent);
        } else {
            result.setHeader("content-type", contentType);
            result.setBodyNotFormatted(responseContent);
        }
        if ("read".equals(requestType) && !requestId.startsWith("-")) {
            Object item = serviceResponse.getResult();
            if (item instanceof Entity) {
                entity = (Entity)item;
                this.storeEntityId(entity, result, requestId);
            } else if (item instanceof EntitySet) {
                EntitySet set = (EntitySet)item;
                this.storeEntityId(set.first(), result, requestId);
            }
        }
        if ("create".equals(requestType) && (createdObject = serviceResponse.getResult()) instanceof Entity) {
            entity = (Entity)createdObject;
            this.storeEntityId(entity, result, requestId);
        }
        return result;
    }

    public void storeEntityId(Entity entity, JsonBatchResultItem result, String requestId) {
        if (entity == null) {
            return;
        }
        PkValue pkValues = entity.getPrimaryKeyValues();
        EntityType entityType = entity.getEntityType();
        result.setIdValue(pkValues);
        result.setEntityType(entityType);
        if (!requestId.startsWith("-")) {
            this.ids.put(requestId, new ContentIdPair(requestId, pkValues, entityType));
        }
    }

    @Override
    public boolean hasNext() {
        if (this.next == null) {
            this.processNextRequest();
        }
        return this.next != null;
    }

    @Override
    public JsonBatchResultItem next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("Iterator reached the end.");
        }
        JsonBatchResultItem myNext = this.next;
        this.next = null;
        return myNext;
    }
}

