/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PrimaryKey;
import de.fraunhofer.iosb.ilt.frostserver.path.UrlHelper;

public final class ContentIdPair {
    public final String key;
    public final PkValue value;
    public final EntityType type;

    public ContentIdPair(String key, PkValue value, EntityType type) {
        this.key = key;
        this.value = value;
        this.type = type;
    }

    public String getKey() {
        return this.key;
    }

    public PkValue getValue() {
        return this.value;
    }

    public EntityType getType() {
        return this.type;
    }

    public String selfLink() {
        return "/" + this.type.plural + "(" + UrlHelper.quoteForUrl((PrimaryKey)this.type.getPrimaryKey(), (PkValue)this.value) + ")";
    }

    public String keyToUrl() {
        return UrlHelper.quoteForUrl((PrimaryKey)this.type.getPrimaryKey(), (PkValue)this.value);
    }

    public String toString() {
        return "ContentIdPair [key=" + this.key + ", value=" + String.valueOf(this.value) + "]";
    }
}

