/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing;

import de.fraunhofer.iosb.ilt.frostserver.formatter.FormatWriterGeneric;
import de.fraunhofer.iosb.ilt.frostserver.formatter.ResultFormatterDefault;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.BatchProcessor;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Batch;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json.JsonBatchProcessor;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json.JsonBatchResponse;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MultipartContent;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MultipartFactory;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceBatchProcessing {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ServiceBatchProcessing.class.getName());
    public static final String PATH_POST_BATCH = "/$batch";
    public static final String REQUEST_TYPE_BATCH = "batchProcess";
    private final CoreSettings settings;
    private boolean streaming = true;

    public ServiceBatchProcessing(CoreSettings settings) {
        this.settings = settings;
    }

    public ServiceBatchProcessing setStreaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    public ServiceResponse executeBatchOperation(Service service, ServiceRequest request, ServiceResponse response) {
        String ct;
        switch (ct = request.getContentType().split(";", 2)[0].toLowerCase()) {
            case "multipart/mixed": {
                MultipartFactory batchFactory = new MultipartFactory();
                Batch batch = batchFactory.createBatch(request.getVersion(), this.settings, false);
                batch.parse(request);
                Batch<MultipartContent> resultContent = new BatchProcessor<MultipartContent>(batchFactory).processBatch(request, service, batch);
                return this.sendResponse(resultContent, response);
            }
            case "application/json": {
                JsonBatchProcessor jsonBatchProcessor = new JsonBatchProcessor(service, request, response);
                JsonBatchResponse batchResponse = jsonBatchProcessor.processRequest(this.streaming);
                try {
                    new ResultFormatterDefault().format(null, null, (Object)batchResponse, false).writeFormatted(response.getWriter());
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to format", (Throwable)ex);
                    throw new IllegalArgumentException("Failed to execute batch.");
                }
                return response;
            }
        }
        throw new IllegalArgumentException("Invalid Content-Type: " + request.getContentType());
    }

    private ServiceResponse sendResponse(Batch batch, ServiceResponse response) {
        response.setCode(200);
        batch.getHeaders().entrySet().forEach(x -> response.addHeaders((String)x.getKey(), (List)x.getValue()));
        try {
            new FormatWriterGeneric(batch.getContent(false)).writeFormatted(response.getWriter());
        }
        catch (IOException ex) {
            LOGGER.error("Failed to format", (Throwable)ex);
        }
        return response;
    }
}

