/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing;

import de.fraunhofer.iosb.ilt.frostserver.model.EntityType;
import de.fraunhofer.iosb.ilt.frostserver.model.core.Entity;
import de.fraunhofer.iosb.ilt.frostserver.model.core.PkValue;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Batch;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.BatchFactory;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Content;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.ContentIdPair;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Part;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Request;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginManager;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponseDefault;
import de.fraunhofer.iosb.ilt.frostserver.service.UpdateMode;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import de.fraunhofer.iosb.ilt.frostserver.util.user.PrincipalExtended;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessor<C extends Content> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchProcessor.class);
    private final BatchFactory<C> batchFactory;

    public BatchProcessor(BatchFactory<C> batchFactory) {
        this.batchFactory = batchFactory;
    }

    public Request processHttpRequest(Service service, Request httpRequest, boolean inChangeSet) {
        Object createdObject;
        CoreSettings coreSettings = service.getSettings();
        PluginManager pluginManager = coreSettings.getPluginManager();
        Version version = pluginManager.getVersion(httpRequest.getVersion());
        List<String> ctHeaders = httpRequest.getInnerHeaders().get("content-type");
        String ct = null;
        if (ctHeaders != null && !ctHeaders.isEmpty()) {
            ct = ctHeaders.get(0);
        }
        String type = service.getRequestType(httpRequest.getMethod(), version, httpRequest.getPath(), ct);
        boolean isCreate = "create".equals(type);
        ServiceRequest serviceRequest = new ServiceRequest().setCoreSettings(coreSettings).setVersion(version).setRequestType(type).setUpdateMode(switch (version.urlPart) {
            case "ODATA_4.0" -> isCreate ? UpdateMode.INSERT_ODATA_40 : UpdateMode.UPDATE_ODATA_40;
            case "ODATA_4.01" -> isCreate ? UpdateMode.INSERT_ODATA_401 : UpdateMode.UPDATE_ODATA_401;
            default -> isCreate ? UpdateMode.INSERT_STA_11 : UpdateMode.UPDATE_STA_11;
        }).setUrl(httpRequest.getPath() == null ? null : StringHelper.urlDecode((String)httpRequest.getPath())).setContent(httpRequest.getData()).setUserPrincipal(PrincipalExtended.fromPrincipal((Principal)httpRequest.getUserPrincipal()));
        PluginService plugin = coreSettings.getPluginManager().getServiceForRequestType(serviceRequest.getVersion(), serviceRequest.getRequestType());
        ServiceResponseDefault serviceResponse = new ServiceResponseDefault();
        if (plugin == null) {
            serviceResponse.setCode(500).setMessage("No plugin to handle requests of type " + serviceRequest.getRequestType() + " for version " + String.valueOf(serviceRequest.getVersion()));
        } else {
            plugin.execute(service, serviceRequest, (ServiceResponse)serviceResponse);
        }
        if ("create".equals(type) && (createdObject = serviceResponse.getResult()) instanceof Entity) {
            Entity entity = (Entity)createdObject;
            httpRequest.setContentIdValue(entity.getPrimaryKeyValues());
            httpRequest.setEntityType(entity.getEntityType());
        }
        Request httpResponse = this.batchFactory.createRequest(serviceRequest.getVersion(), inChangeSet);
        httpResponse.setContentId(httpRequest.getContentId());
        int statusCode = serviceResponse.getCode();
        httpResponse.setStatus(statusCode, "no text");
        Map<String, List<String>> headers = httpResponse.getInnerHeaders();
        serviceResponse.getHeaders().entrySet().forEach(x -> headers.put((String)x.getKey(), (List)x.getValue()));
        String resultFormatted = serviceResponse.getWriter().toString();
        if (statusCode >= 200 && statusCode < 300) {
            if (!StringHelper.isNullOrEmpty((String)resultFormatted)) {
                headers.put("Content-Type", Arrays.asList("application/json; charset=UTF-8"));
                httpResponse.addData(resultFormatted);
            }
        } else {
            httpResponse.setExecuteFailed(true);
            if (!StringHelper.isNullOrEmpty((String)serviceResponse.getMessage())) {
                httpResponse.addData(serviceResponse.getMessage());
            }
        }
        return httpResponse;
    }

    public Content processChangeset(ServiceRequest batchRequest, Service service, Batch changeset) {
        if (changeset.isParseFailed()) {
            Request content = this.batchFactory.createRequest(batchRequest.getVersion(), false);
            for (String error : changeset.getErrors()) {
                content.addData(error);
                content.addData("\n");
            }
            content.setStatus(400, "Bad Request");
            return content;
        }
        service.startTransaction((Principal)batchRequest.getUserPrincipal());
        Batch<C> response = this.batchFactory.createBatch(batchRequest.getVersion(), service.getSettings(), true);
        List parts = changeset.getParts();
        ArrayList<ContentIdPair> contentIds = new ArrayList<ContentIdPair>(parts.size());
        for (Part part : parts) {
            LOGGER.debug("SubPart: {}", part);
            Object content = part.getContent();
            if (content instanceof Request) {
                Request request = (Request)content;
                request.updateUsingContentIds(contentIds);
                request.setUserPrincipal(changeset.getUserPrincipal());
                Request httpResponse = this.processHttpRequest(service, request, true);
                if (httpResponse.isExecuteFailed()) {
                    service.rollbackTransaction();
                    return httpResponse;
                }
                Part<Request> newPart = this.batchFactory.createPart(batchRequest.getVersion(), service.getSettings(), true, "");
                newPart.setContent(httpResponse);
                response.addPart(newPart);
                String contentId = request.getContentId();
                PkValue contentIdValue = request.getContentIdValue();
                EntityType entityType = request.getEntityType();
                if (StringHelper.isNullOrEmpty((String)contentId) || contentIdValue == null || entityType == null) continue;
                contentIds.add(new ContentIdPair("$" + contentId, contentIdValue, entityType));
                continue;
            }
            LOGGER.warn("Only http requests allowed in changset. Found type: {}", (Object)content.getClass().getName());
        }
        service.commitTransaction();
        return response;
    }

    public Batch<C> processBatch(ServiceRequest batchRequest, Service service, Batch<C> batch) {
        Version batchVersion = batchRequest.getVersion();
        Batch<C> batchResponse = this.batchFactory.createBatch(batchVersion, service.getSettings(), false);
        for (Part<C> part : batch.getParts()) {
            LOGGER.debug("Part: {}", part);
            C content = part.getContent();
            if (content instanceof Batch) {
                Batch changset = (Batch)content;
                changset.setUserPrincipal((Principal)batchRequest.getUserPrincipal());
                Content changesetResponse = this.processChangeset(batchRequest, service, changset);
                Part<Content> newPart = this.batchFactory.createPart(batchVersion, service.getSettings(), false, "");
                newPart.setContent(changesetResponse);
                batchResponse.addPart(newPart);
                continue;
            }
            if (content instanceof Request) {
                Request request = (Request)content;
                request.setUserPrincipal((Principal)batchRequest.getUserPrincipal());
                Request httpResponse = this.processHttpRequest(service, request, false);
                Part<Request> newPart = this.batchFactory.createPart(batchVersion, service.getSettings(), false, "");
                newPart.setContent(httpResponse);
                batchResponse.addPart(newPart);
                continue;
            }
            LOGGER.warn("Invalid part type: {}", (Object)content.getClass().getName());
        }
        return batchResponse;
    }
}

