/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Content;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Part;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import java.security.Principal;
import java.util.ArrayList;
import java.util.List;

public abstract class Batch<C extends Content>
implements Content {
    protected final CoreSettings settings;
    protected final List<Part<C>> parts = new ArrayList<Part<C>>();
    protected String logIndent = "";
    protected boolean parseFailed = false;
    protected final List<String> errors = new ArrayList<String>();
    protected final boolean isChangeSet;
    protected final Version batchVersion;
    protected Principal userPrincipal;

    protected Batch(Version batchVersion, CoreSettings settings, boolean isChangeSet) {
        this.batchVersion = batchVersion;
        this.settings = settings;
        this.isChangeSet = isChangeSet;
    }

    public abstract boolean parse(ServiceRequest var1);

    @Override
    public boolean isParseFailed() {
        return this.parseFailed;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public void setLogIndent(String logIndent) {
        this.logIndent = logIndent;
    }

    public List<Part<C>> getParts() {
        return this.parts;
    }

    public Batch<C> addPart(Part<C> part) {
        this.parts.add(part);
        return this;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }
}

