/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch;

import de.fraunhofer.iosb.ilt.frostserver.model.core.Id;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Content;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.ContentIdPair;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Request
implements Content {
    private static final Logger LOGGER = LoggerFactory.getLogger(Request.class);
    private static final String VERSION_REGEX = "/v\\d\\.\\d(/|$)";
    private static final Pattern VERSION_PATTERN = Pattern.compile("/v\\d\\.\\d(/|$)");
    private static final String SLASH = "/";
    protected String logIndent = "";
    protected HttpMethod method;
    protected String version;
    protected String path;
    protected Principal userPrincipal;
    protected final Map<String, String> headersOuter = new HashMap<String, String>();
    protected final Map<String, String> headersInner = new HashMap<String, String>();
    protected boolean parseFailed = false;
    protected boolean executeFailed = false;
    protected final List<String> errors = new ArrayList<String>();
    protected final boolean requireContentId;
    protected String contentId;
    protected Id contentIdValue;
    protected final StringBuilder data = new StringBuilder();
    protected final Version batchVersion;

    protected Request(Version batchVersion) {
        this(batchVersion, false);
    }

    protected Request(Version batchVersion, boolean requireContentId) {
        this.batchVersion = batchVersion;
        this.requireContentId = requireContentId;
    }

    @Override
    public boolean isParseFailed() {
        return this.parseFailed;
    }

    public boolean isExecuteFailed() {
        return this.executeFailed;
    }

    public void setExecuteFailed(boolean executeFailed) {
        this.executeFailed = executeFailed;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getData() {
        return this.data.toString();
    }

    public void addData(String appended) {
        this.data.append(appended);
    }

    public String getContentId() {
        return this.contentId;
    }

    public void setContentId(String contentId) {
        this.contentId = contentId;
    }

    public Id getContentIdValue() {
        return this.contentIdValue;
    }

    public void setContentIdValue(Id contentIdValue) {
        this.contentIdValue = contentIdValue;
    }

    public Map<String, String> getInnerHeaders() {
        return this.headersInner;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headersOuter;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public void setLogIndent(String logIndent) {
        this.logIndent = logIndent;
    }

    public void updateUsingContentIds(List<ContentIdPair> contentIds) {
        for (ContentIdPair pair : contentIds) {
            this.path = this.path.replace(pair.key, pair.value.getUrl());
            int keyIndex = 0;
            String quotedKey = "\"" + pair.key + "\"";
            String value = pair.value.getJson();
            while ((keyIndex = this.data.indexOf(quotedKey, keyIndex)) != -1) {
                this.data.replace(keyIndex, keyIndex + quotedKey.length(), value);
                keyIndex += value.length();
            }
        }
        LOGGER.debug("{}Using replaced path and data with content ids {}: {}, {}", new Object[]{this.logIndent, contentIds, this.path, this.data});
    }

    public abstract void setStatus(int var1, String var2);

    public void parseUrl(String fullUrl) {
        Matcher versionMatcher = VERSION_PATTERN.matcher(fullUrl);
        if (versionMatcher.find()) {
            int versionStart = versionMatcher.start() + 1;
            int versionEnd = versionMatcher.end();
            if (SLASH.equals(versionMatcher.group(1))) {
                this.version = fullUrl.substring(versionStart, versionEnd - 1);
                this.path = fullUrl.substring(versionEnd - 1);
            } else {
                this.version = fullUrl.substring(versionStart, versionEnd);
                this.path = SLASH;
            }
        } else {
            this.version = this.batchVersion.urlPart;
            this.path = SLASH + fullUrl;
        }
    }
}

