/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.ServiceBatchProcessing;
import de.fraunhofer.iosb.ilt.frostserver.service.Plugin;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginRootDocument;
import de.fraunhofer.iosb.ilt.frostserver.service.PluginService;
import de.fraunhofer.iosb.ilt.frostserver.service.Service;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceResponse;
import de.fraunhofer.iosb.ilt.frostserver.settings.ConfigDefaults;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.settings.Settings;
import de.fraunhofer.iosb.ilt.frostserver.settings.annotation.DefaultValueBoolean;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class PluginBatchProcessing
implements PluginService,
PluginRootDocument,
ConfigDefaults {
    @DefaultValueBoolean(value=true)
    public static final String TAG_ENABLE_BATCH_PROCESSING = "batchProcessing.enable";
    private static final String REQUIREMENT_BATCH_PROCESSING = "http://www.opengis.net/spec/iot_sensing/1.1/req/batch-request/batch-request";
    private static final String REQUIREMENT_JSON_BATCH_PROCESSING = "https://fraunhoferiosb.github.io/FROST-Server/extensions/JsonBatchRequest.html";
    private CoreSettings settings;
    private boolean enabled;

    public void init(CoreSettings settings) {
        this.settings = settings;
        Settings pluginSettings = settings.getPluginSettings();
        this.enabled = pluginSettings.getBoolean(TAG_ENABLE_BATCH_PROCESSING, this.getClass());
        if (this.enabled) {
            settings.getPluginManager().registerPlugin((Plugin)this);
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void modifyServiceDocument(ServiceRequest request, Map<String, Object> result) {
        Map serverSettings = (Map)result.get("serverSettings");
        if (serverSettings == null) {
            return;
        }
        Set extensionList = (Set)serverSettings.get("conformance");
        extensionList.add(REQUIREMENT_BATCH_PROCESSING);
        extensionList.add(REQUIREMENT_JSON_BATCH_PROCESSING);
    }

    public Collection<Version> getVersions() {
        return this.settings.getPluginManager().getVersions().values();
    }

    public Collection<String> getVersionedUrlPaths() {
        return Arrays.asList("/$batch");
    }

    public Collection<String> getRequestTypes() {
        return Arrays.asList("batchProcess");
    }

    public String getRequestTypeFor(Version version, String path, HttpMethod method, String contentType) {
        if (method.equals((Object)HttpMethod.POST) && path.equals("/$batch")) {
            return "batchProcess";
        }
        throw new IllegalArgumentException("Method " + method + "not valid for path " + path);
    }

    public ServiceResponse execute(Service service, ServiceRequest request, ServiceResponse response) {
        return new ServiceBatchProcessing(this.settings).executeBatchOperation(service, request, response);
    }
}

