/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart;

import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MultipartContent;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringContent
implements MultipartContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringContent.class);
    private StringBuilder content;
    private String logIndent = "";

    @Override
    public void parseLine(String line) {
        this.content.append(line).append('\n');
    }

    @Override
    public boolean isParseFailed() {
        return false;
    }

    @Override
    public List<String> getErrors() {
        return Collections.emptyList();
    }

    @Override
    public void stripLastNewline() {
        int lastIdx = this.content.length() - 1;
        if (lastIdx < 0) {
            LOGGER.debug("{}No content to strip the last newline from.", (Object)this.logIndent);
        }
        if (this.content.charAt(lastIdx) != '\n') {
            LOGGER.error("{}Last character was not a newline, but: {}", (Object)this.logIndent, (Object)Character.valueOf(this.content.charAt(lastIdx)));
            return;
        }
        this.content.deleteCharAt(lastIdx);
    }

    @Override
    public MultipartContent.IsFinished isFinished() {
        return MultipartContent.IsFinished.UNKNOWN;
    }

    @Override
    public void setLogIndent(String logIndent) {
        this.logIndent = logIndent;
    }

    @Override
    public String getContent(boolean allHeaders) {
        return this.content.toString();
    }

    public void setContent(StringBuilder content) {
        this.content = content;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }
}

