/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart;

import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MixedContent;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeaderUtils.class);
    private static final String CONTENT_ID_NAME = "content-id";
    private static final String CONTENT_ID_REGEX = "^[0-9a-zA-Z.~_-]+$";
    private static final String HOST_NAME = "host";
    private static final String HOST_REGEX = "^[0-9a-zA-Z:._-]+$";
    private static final String CONTENT_TYPE_NAME = "content-type";
    private static final String CONTENT_TYPE_REGEX = "^[0-9a-zA-Z/_-]+$";
    private static final String CHARSET_NAME = "charset";
    private static final String CHARSET_REGEX = "^[0-9a-zA-Z._-]+$";
    private static final String CONTENT_LENGTH_NAME = "content-length";
    private static final String CONTENT_LENGTH_REGEX = "^[0-9]+$";
    private static final Map<String, Validator> VALIDATORS = new HashMap<String, Validator>();

    private HeaderUtils() {
    }

    public static void addHeader(String line, Map<String, String> headers) {
        HeaderUtils.addHeader(line, headers, "");
    }

    public static void addHeader(String line, Map<String, String> headers, String logIndent) {
        Matcher matcher = MixedContent.HEADER_PATTERN.matcher(line);
        if (matcher.find()) {
            String value;
            String name = matcher.group(1).trim().toLowerCase();
            if (HeaderUtils.validateHeader(name, value = matcher.group(2).trim())) {
                headers.put(name, value);
                LOGGER.debug("{}Found header '{}' : '{}'", new Object[]{logIndent, name, value});
            } else {
                LOGGER.debug("{}Header '{}' has invalid value: '{}'", new Object[]{logIndent, name, value});
            }
        } else {
            LOGGER.error("{}Found non-header line in headers: '{}'", (Object)logIndent, (Object)line);
            return;
        }
        String rest = line.substring(matcher.end());
        if (StringHelper.isNullOrEmpty((String)rest)) {
            return;
        }
        Matcher subHeaderMatcher = MixedContent.SUB_HEADER_PATTERN.matcher(rest);
        while (subHeaderMatcher.find()) {
            String subValue;
            String subName = subHeaderMatcher.group(1).trim().toLowerCase();
            if (HeaderUtils.validateHeader(subName, subValue = subHeaderMatcher.group(2).trim())) {
                headers.put(subName, subValue);
                LOGGER.debug("{}  Found subheader '{}' : '{}'", new Object[]{logIndent, subName, subValue});
                continue;
            }
            LOGGER.warn("{}Header '{}' has invalid value: '{}'", new Object[]{logIndent, subName, subValue});
        }
    }

    public static boolean validateHeader(String name, String value) {
        Validator validator = VALIDATORS.get(name);
        if (validator == null) {
            LOGGER.warn("No validation rules for header {}.", (Object)name);
            return true;
        }
        return validator.validate(value);
    }

    public static String generateStatusLine(int statusCode, String statusPhrase) {
        return "http/1.1 " + statusCode + " " + statusPhrase;
    }

    static {
        VALIDATORS.put(CONTENT_ID_NAME, new ValidatorRegex(CONTENT_ID_REGEX));
        VALIDATORS.put(HOST_NAME, new ValidatorRegex(HOST_REGEX));
        VALIDATORS.put(CONTENT_TYPE_NAME, new ValidatorRegex(CONTENT_TYPE_REGEX));
        VALIDATORS.put(CHARSET_NAME, new ValidatorRegex(CHARSET_REGEX));
        VALIDATORS.put(CONTENT_LENGTH_NAME, new ValidatorRegex(CONTENT_LENGTH_REGEX));
    }

    private static interface Validator {
        public boolean validate(String var1);
    }

    private static final class ValidatorRegex
    implements Validator {
        private final Pattern pattern;

        public ValidatorRegex(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public boolean validate(String value) {
            return this.pattern.matcher(value).matches();
        }
    }
}

