/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.RawValue;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Batch;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Content;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Part;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json.JsonRequest;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonBatch
extends Batch<Content> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonBatch.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public JsonBatch(Version batchVersion, CoreSettings settings, boolean isChangeSet) {
        super(batchVersion, settings, isChangeSet);
    }

    @Override
    public boolean parse(ServiceRequest serviceRequest) {
        try {
            JsonNode rootNode = OBJECT_MAPPER.readTree(serviceRequest.getContentString());
            JsonNode reqNode = rootNode.path("requests");
            Iterator requests = reqNode.elements();
            HashMap<String, Batch<Content>> atomicityGroupToBatch = new HashMap<String, Batch<Content>>();
            while (requests.hasNext()) {
                JsonNode req = (JsonNode)requests.next();
                Part<JsonRequest> reqPart = new Part<JsonRequest>(this.batchVersion, this.settings, false, "");
                if (req.has("atomicityGroup")) {
                    Batch<Content> group = this.getAtomicityGroup(atomicityGroupToBatch, req.get("atomicityGroup").textValue());
                    group.addPart(reqPart);
                    reqPart.setInChangeSet(true);
                } else {
                    this.addPart(reqPart);
                }
                JsonRequest request = new JsonRequest(this.batchVersion);
                reqPart.setContent(request);
                for (String property : Arrays.asList("id", "method", "url")) {
                    if (!StringHelper.isNullOrEmpty((String)property)) continue;
                    this.parseFailed = true;
                    this.errors.add("All requests must have a valid " + property);
                }
                if (this.parseFailed) continue;
                request.setContentId(req.get("id").textValue());
                request.setMethod(HttpMethod.fromString((String)req.get("method").textValue()));
                request.parseUrl(req.get("url").textValue());
                if (!req.has("body")) continue;
                request.addData(OBJECT_MAPPER.writeValueAsString((Object)req.get("body")));
            }
            return true;
        }
        catch (IOException exc) {
            LOGGER.error("Failed to read data.", (Throwable)exc);
            return false;
        }
    }

    private Batch<Content> getAtomicityGroup(Map<String, Batch<Content>> atomicityGroupToBatch, String atomicityGroupId) {
        JsonBatch group;
        if (atomicityGroupToBatch.containsKey(atomicityGroupId)) {
            group = atomicityGroupToBatch.get(atomicityGroupId);
        } else {
            group = new JsonBatch(this.batchVersion, this.settings, true);
            atomicityGroupToBatch.put(atomicityGroupId, group);
            Part<JsonBatch> atomicityGroupPart = new Part<JsonBatch>(this.batchVersion, this.settings, true, "");
            atomicityGroupPart.setContent(group);
            this.addPart(atomicityGroupPart);
        }
        return group;
    }

    @Override
    public String getContent(boolean allHeaders) {
        ArrayList<String> responses = new ArrayList<String>();
        this.addResponses(responses, this);
        ObjectNode rootNode = OBJECT_MAPPER.createObjectNode();
        ArrayNode arrayNode = OBJECT_MAPPER.createArrayNode();
        responses.forEach(s -> arrayNode.addRawValue(new RawValue(s)));
        rootNode.set("responses", (JsonNode)arrayNode);
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)rootNode);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to generate JSON.", ex);
        }
    }

    private void addResponses(List<String> responses, Batch<Content> batch) {
        for (Part<Content> part : batch.getParts()) {
            Content partContent = part.getContent();
            if (partContent instanceof Batch) {
                this.addResponses(responses, (Batch)partContent);
                continue;
            }
            responses.add(partContent.getContent(false));
        }
    }

    @Override
    public Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        return headers;
    }
}

