/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Batch;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Part;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MixedPart;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MultipartContent;
import de.fraunhofer.iosb.ilt.frostserver.service.ServiceRequest;
import de.fraunhofer.iosb.ilt.frostserver.settings.CoreSettings;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MixedContent
extends Batch<MultipartContent>
implements MultipartContent {
    public static final String BOUNDARY_REGEX = "boundary=[\"]?([A-Za-z0-9'()+_,-./:=?]+)[\"]?";
    public static final Pattern BOUNDARY_PATTERN = Pattern.compile("boundary=[\"]?([A-Za-z0-9'()+_,-./:=?]+)[\"]?");
    public static final String HEADER_REGEX = "^([-A-Za-z]+):([^;]+)(;[ ]*)?";
    public static final Pattern HEADER_PATTERN = Pattern.compile("^([-A-Za-z]+):([^;]+)(;[ ]*)?");
    public static final String SUB_HEADER_REGEX = "([-A-Za-z]+)=([^;]+)(;[ ]*)?";
    public static final Pattern SUB_HEADER_PATTERN = Pattern.compile("([-A-Za-z]+)=([^;]+)(;[ ]*)?");
    private static final char[] BOUNDARY_CHARS = "-_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
    private static final Logger LOGGER = LoggerFactory.getLogger(MixedContent.class);
    private static final Random RAND = new Random();
    private String boundary;
    private String boundaryPart;
    private String boundaryEnd;
    private State state = State.PREAMBLE;
    private MultipartContent.IsFinished finished = MultipartContent.IsFinished.UNFINISHED;
    private MixedPart currentPart;

    public MixedContent(Version batchVersion, CoreSettings settings, boolean isChangeSet) {
        super(batchVersion, settings, isChangeSet);
    }

    @Override
    public boolean parse(ServiceRequest request) {
        boolean bl;
        String contentType = request.getContentType();
        Matcher matcher = BOUNDARY_PATTERN.matcher(contentType);
        if (!matcher.find()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}Could not find boundary in content type: {}", (Object)this.logIndent, (Object)StringHelper.cleanForLogging((String)contentType));
            }
            return false;
        }
        String boundaryHeader = matcher.group(1);
        this.setBoundaryHeader(boundaryHeader);
        BufferedReader reader = new BufferedReader(request.getContentReader());
        try {
            String line;
            while (this.finished != MultipartContent.IsFinished.FINISHED && (line = reader.readLine()) != null) {
                this.parseLine(line);
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exc) {
                LOGGER.error("Failed to read data.", (Throwable)exc);
                return false;
            }
        }
        reader.close();
        return bl;
    }

    public MixedContent setBoundaryHeader(String boundaryHeader) {
        this.boundary = boundaryHeader;
        this.boundaryPart = "--" + boundaryHeader;
        this.boundaryEnd = this.boundaryPart + "--";
        return this;
    }

    @Override
    public void parseLine(String line) {
        try {
            this.parseLineInternal(line);
        }
        catch (IllegalArgumentException exc) {
            LOGGER.info("Parse error on multipart content.", (Throwable)exc);
            this.parseFailed = true;
            this.errors.add(exc.getMessage());
        }
    }

    public void parseLineInternal(String line) {
        LOGGER.trace("{}Read line: {}", (Object)this.logIndent, (Object)line);
        switch (this.state) {
            case PREAMBLE: {
                this.parsePreamble(line);
                break;
            }
            case PARTCONTENT: {
                this.parsePartContent(line);
                break;
            }
            case PARTDONE: {
                this.parsePartDone(line);
                break;
            }
            case EPILOGUE: {
                LOGGER.debug("{}Epilogue line: {}", (Object)this.logIndent, (Object)line);
                break;
            }
            default: {
                LOGGER.warn("{}Uhandled state: {}.", (Object)this.logIndent, (Object)this.state);
            }
        }
    }

    private void parsePreamble(String line) {
        if (this.boundaryPart.equals(line.trim())) {
            this.setState(State.PARTCONTENT);
            this.currentPart = new MixedPart(this.batchVersion, this.settings, this.isChangeSet, this.logIndent + "  ");
        }
    }

    private void parsePartContent(String line) {
        boolean checkBoundary;
        if (this.currentPart == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("{}Content without part: {}", (Object)this.logIndent, (Object)StringHelper.cleanForLogging((String)line));
            }
            return;
        }
        boolean bl = checkBoundary = this.currentPart.isFinished() != MultipartContent.IsFinished.UNFINISHED;
        if (checkBoundary && this.boundaryPart.equals(line.trim())) {
            LOGGER.debug("{}Found new part", (Object)this.logIndent);
            this.currentPart.stripLastNewline();
            this.parts.add(this.currentPart);
            this.currentPart = new MixedPart(this.batchVersion, this.settings, this.isChangeSet, this.logIndent + "  ");
            this.setState(State.PARTCONTENT);
        } else if (checkBoundary && this.boundaryEnd.equals(line.trim())) {
            LOGGER.debug("{}Found end of multipart content", (Object)this.logIndent);
            this.currentPart.stripLastNewline();
            this.parts.add(this.currentPart);
            this.currentPart = null;
            this.finishParsing();
        } else {
            this.currentPart.appendLine(line);
            if (this.currentPart.isFinished() == MultipartContent.IsFinished.FINISHED) {
                LOGGER.debug("{}Part declared done", (Object)this.logIndent);
                this.parts.add(this.currentPart);
                this.currentPart = null;
                this.setState(State.PARTDONE);
            }
        }
    }

    private void parsePartDone(String line) {
        if (this.boundaryPart.equals(line.trim())) {
            LOGGER.debug("{}Found new part", (Object)this.logIndent);
            this.currentPart = new MixedPart(this.batchVersion, this.settings, this.isChangeSet, this.logIndent + "  ");
            this.setState(State.PARTCONTENT);
        } else if (this.boundaryEnd.equals(line.trim())) {
            LOGGER.debug("{}Found end of multipart content", (Object)this.logIndent);
            this.finishParsing();
        } else if (!StringHelper.isNullOrEmpty((String)line) && LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}Ignoring line: {}", (Object)this.logIndent, (Object)StringHelper.cleanForLogging((String)line));
        }
    }

    private void finishParsing() {
        this.setState(State.EPILOGUE);
        this.finished = MultipartContent.IsFinished.FINISHED;
        for (Part part : this.parts) {
            if (!part.getContent().isParseFailed()) continue;
            this.parseFailed = true;
            this.errors.addAll(part.getContent().getErrors());
        }
        LOGGER.debug("{}Found {} parts", (Object)this.logIndent, (Object)this.parts.size());
    }

    @Override
    public void stripLastNewline() {
    }

    private void setState(State state) {
        LOGGER.debug("{}Now in state: {}", (Object)this.logIndent, (Object)state);
        this.state = state;
    }

    @Override
    public MultipartContent.IsFinished isFinished() {
        return this.finished;
    }

    @Override
    public String getContent(boolean allHeaders) {
        if (this.boundary == null) {
            this.generateBoundary();
        }
        StringBuilder content = new StringBuilder();
        if (allHeaders) {
            content.append("Content-Type: multipart/mixed; boundary=").append(this.boundary).append('\n');
            content.append('\n');
        }
        for (Part part : this.parts) {
            content.append(this.boundaryPart).append('\n');
            MultipartContent partContent = (MultipartContent)part.getContent();
            content.append(partContent.getContent(true));
            content.append('\n');
        }
        content.append(this.boundaryEnd);
        return content.toString();
    }

    @Override
    public Map<String, String> getHeaders() {
        if (this.boundary == null) {
            this.generateBoundary();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "multipart/mixed; boundary=" + this.boundary);
        return headers;
    }

    private void generateBoundary() {
        StringBuilder retval = new StringBuilder();
        for (int i = 0; i < 40; ++i) {
            retval.append(BOUNDARY_CHARS[RAND.nextInt(BOUNDARY_CHARS.length)]);
        }
        this.boundary = retval.toString();
        this.boundaryPart = "--" + this.boundary;
        this.boundaryEnd = this.boundaryPart + "--";
    }

    private static enum State {
        PREAMBLE,
        PARTCONTENT,
        PARTDONE,
        EPILOGUE;

    }
}

