/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRawValue;
import de.fraunhofer.iosb.ilt.frostserver.json.serialize.JsonWriter;
import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Request;
import java.io.IOException;

public class JsonRequest
extends Request {
    private int status;

    public JsonRequest(Version batchVersion) {
        this(batchVersion, true);
    }

    public JsonRequest(Version batchVersion, boolean requireContentId) {
        super(batchVersion, true);
    }

    @Override
    public String getContent(boolean allHeaders) {
        try {
            return JsonWriter.writeObject((Object)new ODataResponse(this.getContentId(), this.status, this.data.length() > 0 ? this.data.toString() : null, this.getHttpHeaders().get("Location")));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to generate JSON.", ex);
        }
    }

    @Override
    public void setStatus(int status, String text) {
        this.status = status;
    }

    public String toString() {
        return "JsonRequest [status=" + this.status + ", logIndent=" + this.logIndent + ", method=" + this.method + ", version=" + this.version + ", path=" + this.path + ", headersOuter=" + this.headersOuter + ", headersInner=" + this.headersInner + ", parseFailed=" + this.parseFailed + ", executeFailed=" + this.executeFailed + ", errors=" + this.errors + ", requireContentId=" + this.requireContentId + ", contentId=" + this.contentId + ", contentIdValue=" + this.contentIdValue + ", data=" + this.data + ", batchVersion=" + this.batchVersion + "]";
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class ODataResponse {
        public final String id;
        public final int status;
        @JsonRawValue
        public final String body;
        public final String location;

        public ODataResponse(String id, int status, String body, String location) {
            this.id = id;
            this.status = status;
            this.body = body;
            this.location = location;
        }
    }
}

