/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart;

import de.fraunhofer.iosb.ilt.frostserver.path.Version;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.batch.Request;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.HeaderUtils;
import de.fraunhofer.iosb.ilt.frostserver.plugin.batchprocessing.multipart.MultipartContent;
import de.fraunhofer.iosb.ilt.frostserver.util.HttpMethod;
import de.fraunhofer.iosb.ilt.frostserver.util.StringHelper;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpContent
extends Request
implements MultipartContent {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpContent.class);
    private static final String COMMAND_REGEX = "^(GET|PATCH|POST|PUT|DELETE) ([^ ]+)( HTTP/[0-9]\\.[0-9])?";
    private static final Pattern COMMAND_PATTERN = Pattern.compile("^(GET|PATCH|POST|PUT|DELETE) ([^ ]+)( HTTP/[0-9]\\.[0-9])?");
    private State parseState = State.PREHEADERS;
    private String statusLine;

    public HttpContent(Version batchVersion) {
        this(batchVersion, false);
    }

    public HttpContent(Version batchVersion, boolean requireContentId) {
        super(batchVersion, requireContentId);
    }

    @Override
    public void parseLine(String line) {
        switch (this.parseState) {
            case PREHEADERS: {
                this.parsePreHeaderLine(line);
                break;
            }
            case COMMAND: {
                this.parseCommandLine(line);
                break;
            }
            case HEADERS: {
                this.parseHeaderLine(line);
                break;
            }
            case DATA: {
                this.data.append(line).append('\n');
                break;
            }
            default: {
                LOGGER.warn("Unknow parseState: {}", (Object)this.parseState);
            }
        }
    }

    private void parsePreHeaderLine(String line) {
        if (line.trim().isEmpty()) {
            this.parseState = State.COMMAND;
            if (this.requireContentId) {
                this.contentId = (String)this.headersOuter.get("content-id");
                if (StringHelper.isNullOrEmpty((String)this.contentId)) {
                    this.parseFailed = true;
                    this.errors.add("All Changeset parts must have a valid content-id header.");
                }
            }
        } else {
            HeaderUtils.addHeader(line, this.headersOuter, this.logIndent);
        }
    }

    private void parseCommandLine(String line) {
        if (line.trim().isEmpty()) {
            LOGGER.warn("{}Found extra empty line before command.", (Object)this.logIndent);
        } else {
            this.parseCommand(line);
            this.parseState = State.HEADERS;
        }
    }

    private void parseHeaderLine(String line) {
        if (line.trim().isEmpty()) {
            this.parseState = State.DATA;
        } else {
            HeaderUtils.addHeader(line, this.headersInner, this.logIndent);
        }
    }

    private void parseCommand(String line) {
        Matcher commandMatcher = COMMAND_PATTERN.matcher(line);
        if (!commandMatcher.find()) {
            LOGGER.error("{}Not a command: {}", (Object)this.logIndent, (Object)line);
            return;
        }
        this.method = HttpMethod.fromString((String)commandMatcher.group(1));
        this.parseUrl(commandMatcher.group(2));
        LOGGER.debug("{}Found command: {}, version: {}, path: {}", new Object[]{this.logIndent, this.method, this.version, this.path});
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public void setStatusLine(String statusLine) {
        this.statusLine = statusLine;
    }

    @Override
    public void setStatus(int code, String text) {
        this.setStatusLine(HeaderUtils.generateStatusLine(code, text));
    }

    @Override
    public String getContent(boolean allHeaders) {
        StringBuilder content = new StringBuilder();
        if (allHeaders) {
            content.append("Content-Type: application/http\n");
            if (this.contentId != null) {
                content.append("Content-ID: ").append(this.contentId).append('\n');
            }
            content.append('\n');
        }
        if (this.statusLine != null) {
            content.append(this.statusLine).append('\n');
        }
        for (Map.Entry entry : this.headersInner.entrySet()) {
            content.append((String)entry.getKey()).append(": ").append((String)entry.getValue()).append('\n');
        }
        content.append('\n');
        content.append((CharSequence)this.data);
        return content.toString();
    }

    @Override
    public void stripLastNewline() {
        int lastIdx = this.data.length() - 1;
        if (lastIdx < 0) {
            LOGGER.debug("{}No content to strip the last newline from.", (Object)this.logIndent);
            return;
        }
        if (this.data.charAt(lastIdx) != '\n') {
            LOGGER.error("{}Last character was not a newline, but: {}", (Object)this.logIndent, (Object)Character.valueOf(this.data.charAt(lastIdx)));
            return;
        }
        this.data.deleteCharAt(lastIdx);
    }

    @Override
    public MultipartContent.IsFinished isFinished() {
        return MultipartContent.IsFinished.UNKNOWN;
    }

    private static enum State {
        PREHEADERS,
        COMMAND,
        HEADERS,
        DATA;

    }
}

